/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;

public class Artwork {
    private String filename;
    Vector<ArtworkItem> artworkItems;
    byte[] artworkBytes;

    public Artwork(File file) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.filename = file.getName();
        if (this.filename.equals("Keyboard-StandardQWERTY.artwork") && file.length() == 13498368L) {
            this.initKeyboard_StandardQWERTY_ver102();
            this.artworkBytes = new byte[13498368];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else if (this.filename.equals("Keyboard-Common.artwork") && file.length() == 399232L) {
            this.initKeyboard_Common_ver102();
            this.artworkBytes = new byte[399232];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else if (this.filename.equals("Other.artwork") && file.length() == 1931712L) {
            this.initOther_ver102();
            this.artworkBytes = new byte[1931712];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else if (this.filename.equals("Other.artwork") && file.length() == 3185088L) {
            this.initOther_ver111();
            this.artworkBytes = new byte[3185088];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else if (this.filename.equals("Keyboard-Japanese.artwork") && file.length() == 2578432L) {
            this.initKeyboard_Japanese_ver111();
            this.artworkBytes = new byte[2578432];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else if (this.filename.equals("Keyboard-Latin.artwork") && file.length() == 16435200L) {
            this.initKeyboard_Latin_ver111();
            this.artworkBytes = new byte[16435200];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else if (this.filename.equals("Keyboard-Common.artwork") && file.length() == 1042432L) {
            this.initKeyboard_Common_ver111();
            this.artworkBytes = new byte[1042432];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else if (this.filename.equals("MobilePhonePackedImages.artwork") && file.length() == 1422592L) {
            this.initMobilePhonePackedImages_ver102();
            this.artworkBytes = new byte[1422592];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else if (this.filename.equals("Keyboard-Common.artwork") && file.length() == 1153024L) {
            this.initKeyboard_Common_ver114();
            this.artworkBytes = new byte[1153024];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else if (this.filename.equals("Keyboard-Latin.artwork") && file.length() == 16574464L) {
            this.initKeyboard_Latin_ver114();
            this.artworkBytes = new byte[16574464];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else if (this.filename.equals("Other.artwork") && file.length() == 3393984L) {
            this.initOther_ver114();
            this.artworkBytes = new byte[3393984];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else if (this.filename.equals("Keyboard-Japanese.artwork") && file.length() == 4081664L) {
            this.initKeyboard_Japanese_ver114();
            this.artworkBytes = new byte[4081664];
            int n = fileInputStream.read(this.artworkBytes);
            if (n != this.artworkBytes.length) {
                throw new IOException("Unable to read full artwork file");
            }
        } else {
            throw new IllegalArgumentException("Unsupported artwork type");
        }
    }

    public void importItems(File file) throws IOException {
        if (!file.exists() || !file.canWrite()) {
            throw new IOException("Unable to read and write directory " + file.getAbsolutePath());
        }
        int n = 0;
        for (ArtworkItem object2 : this.artworkItems) {
            File file2 = new File(file.getAbsolutePath() + "/" + object2.getFilename());
            if (!file2.exists() || !file2.canRead()) continue;
            BufferedImage bufferedImage = ImageIO.read(file2);
            if (bufferedImage.getHeight() == object2.getHeight() && bufferedImage.getWidth() == object2.getWidth()) {
                this.importImage(object2, bufferedImage);
                System.out.println(file2.getAbsolutePath() + " imported");
                ++n;
                continue;
            }
            System.out.println("WARNING " + file2.getAbsolutePath() + " is not valid to import");
        }
        System.out.println("imported " + n + " images");
        File file3 = new File(file.getAbsolutePath() + "/" + this.filename);
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        fileOutputStream.write(this.artworkBytes);
        fileOutputStream.flush();
        fileOutputStream.close();
        System.out.println("New artwork file is stored to " + file3.getAbsolutePath());
    }

    private void importImage(ArtworkItem artworkItem, BufferedImage bufferedImage) {
        for (int i = 0; i < artworkItem.getHeight(); ++i) {
            for (int j = 0; j < artworkItem.getWidth(); ++j) {
                int n = artworkItem.getPos() + (i * artworkItem.getMemWidth() + j) * 4;
                int n2 = bufferedImage.getRGB(j, i);
                int n3 = n2 & 0xFF;
                int n4 = n2 >> 8 & 0xFF;
                int n5 = n2 >> 16 & 0xFF;
                int n6 = n2 >> 24 & 0xFF;
                this.artworkBytes[n + 3] = (byte)(n2 >> 24 & 0xFF);
                this.artworkBytes[n] = (byte)(n2 & 0xFF);
                this.artworkBytes[n + 1] = (byte)(n2 >> 8 & 0xFF);
                this.artworkBytes[n + 2] = (byte)(n2 >> 16 & 0xFF);
            }
        }
    }

    public void extractItems(File file) throws IOException {
        if (!file.exists() || !file.canWrite()) {
            throw new IOException("Unable to write into directory " + file.getAbsolutePath());
        }
        int n = 0;
        for (ArtworkItem artworkItem : this.artworkItems) {
            BufferedImage bufferedImage = this.extractImage(artworkItem);
            File file2 = new File(file.getAbsolutePath() + "/" + artworkItem.getFilename());
            ImageIO.write((RenderedImage)bufferedImage, "png", file2);
            System.out.println(file2.getAbsolutePath() + " extracted");
            ++n;
        }
        System.out.println("extracted " + n + " images");
    }

    private BufferedImage extractImage(ArtworkItem artworkItem) {
        BufferedImage bufferedImage = new BufferedImage(artworkItem.getWidth(), artworkItem.getHeight(), 2);
        for (int i = 0; i < artworkItem.getHeight(); ++i) {
            for (int j = 0; j < artworkItem.getWidth(); ++j) {
                int n = artworkItem.getPos() + (i * artworkItem.getMemWidth() + j) * 4;
                int n2 = this.artworkBytes[n + 3] & 0xFF;
                n2 <<= 8;
                n2 |= this.artworkBytes[n + 2] & 0xFF;
                n2 <<= 8;
                n2 |= this.artworkBytes[n + 1] & 0xFF;
                n2 <<= 8;
                bufferedImage.setRGB(j, i, n2 |= this.artworkBytes[n + 0] & 0xFF);
            }
        }
        return bufferedImage;
    }

    private void initMobilePhonePackedImages_ver102() {
        this.artworkItems = new Vector(31);
        this.artworkItems.add(new ArtworkItem(72, 71, 0, "MobilePhonePackedImages-1.png"));
        this.artworkItems.add(new ArtworkItem(40, 50, 20480, "MobilePhonePackedImages-2.png"));
        this.artworkItems.add(new ArtworkItem(72, 71, 28672, "MobilePhonePackedImages-3.png"));
        this.artworkItems.add(new ArtworkItem(40, 50, 49152, "MobilePhonePackedImages-4.png"));
        this.artworkItems.add(new ArtworkItem(40, 50, 57344, "MobilePhonePackedImages-5.png"));
        this.artworkItems.add(new ArtworkItem(72, 71, 65536, "MobilePhonePackedImages-6.png"));
        this.artworkItems.add(new ArtworkItem(96, 116, 86016, "MobilePhonePackedImages-7.png"));
        this.artworkItems.add(new ArtworkItem(96, 116, 131072, "MobilePhonePackedImages-8.png"));
        this.artworkItems.add(new ArtworkItem(104, 108, 176128, "MobilePhonePackedImages-9.png"));
        this.artworkItems.add(new ArtworkItem(96, 116, 221184, "MobilePhonePackedImages-10.png"));
        this.artworkItems.add(new ArtworkItem(96, 116, 266240, "MobilePhonePackedImages-11.png"));
        this.artworkItems.add(new ArtworkItem(104, 118, 311296, "MobilePhonePackedImages-12.png"));
        this.artworkItems.add(new ArtworkItem(96, 116, 360448, "MobilePhonePackedImages-13.png"));
        this.artworkItems.add(new ArtworkItem(96, 116, 405504, "MobilePhonePackedImages-14.png"));
        this.artworkItems.add(new ArtworkItem(104, 108, 450560, "MobilePhonePackedImages-15.png"));
        this.artworkItems.add(new ArtworkItem(96, 116, 495616, "MobilePhonePackedImages-16.png"));
        this.artworkItems.add(new ArtworkItem(96, 116, 540672, "MobilePhonePackedImages-17.png"));
        this.artworkItems.add(new ArtworkItem(104, 118, 585728, "MobilePhonePackedImages-18.png"));
        this.artworkItems.add(new ArtworkItem(48, 42, 634880, "MobilePhonePackedImages-19.png"));
        this.artworkItems.add(new ArtworkItem(48, 42, 643072, "MobilePhonePackedImages-20.png"));
        this.artworkItems.add(new ArtworkItem(48, 42, 651264, "MobilePhonePackedImages-21.png"));
        this.artworkItems.add(new ArtworkItem(48, 42, 659456, "MobilePhonePackedImages-22.png"));
        this.artworkItems.add(new ArtworkItem(48, 42, 667648, "MobilePhonePackedImages-23.png"));
        this.artworkItems.add(new ArtworkItem(48, 42, 675840, "MobilePhonePackedImages-24.png"));
        this.artworkItems.add(new ArtworkItem(48, 42, 684032, "MobilePhonePackedImages-25.png"));
        this.artworkItems.add(new ArtworkItem(48, 42, 692224, "MobilePhonePackedImages-26.png"));
        this.artworkItems.add(new ArtworkItem(48, 42, 700416, "MobilePhonePackedImages-27.png"));
        this.artworkItems.add(new ArtworkItem(48, 42, 708608, "MobilePhonePackedImages-28.png"));
        this.artworkItems.add(new ArtworkItem(8, 128, 716800, "MobilePhonePackedImages-29.png"));
        this.artworkItems.add(new ArtworkItem(320, 273, 720896, "MobilePhonePackedImages-30.png"));
        this.artworkItems.add(new ArtworkItem(320, 273, 0x106000, "MobilePhonePackedImages-31.png"));
    }

    private void initOther_ver102() {
        this.artworkItems = new Vector(332);
        this.artworkItems.add(new ArtworkItem(16, 20, 0, "Other-ver102_0.png"));
        this.artworkItems.add(new ArtworkItem(16, 20, 4096, "Other-ver102_1.png"));
        this.artworkItems.add(new ArtworkItem(1, 222, 8192, "Other-ver102_2.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 16384, "Other-ver102_3.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 20480, "Other-ver102_4.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 24576, "Other-ver102_5.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 28672, "Other-ver102_6.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 32768, "Other-ver102_7.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 36864, "Other-ver102_8.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 40960, "Other-ver102_9.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 45056, "Other-ver102_10.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 49152, "Other-ver102_11.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 53248, "Other-ver102_12.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 57344, "Other-ver102_13.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 61440, "Other-ver102_14.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 65536, "Other-ver102_15.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 73728, "Other-ver102_16.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 77824, "Other-ver102_17.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 81920, "Other-ver102_18.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 86016, "Other-ver102_19.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 90112, "Other-ver102_20.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 94208, "Other-ver102_21.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 102400, "Other-ver102_22.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 106496, "Other-ver102_23.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 110592, "Other-ver102_24.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 114688, "Other-ver102_25.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 118784, "Other-ver102_26.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 122880, "Other-ver102_27.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 131072, "Other-ver102_28.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 135168, "Other-ver102_29.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 139264, "Other-ver102_30.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 143360, "Other-ver102_31.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 147456, "Other-ver102_32.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 151552, "Other-ver102_33.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 155648, "Other-ver102_34.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 159744, "Other-ver102_35.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 163840, "Other-ver102_36.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 167936, "Other-ver102_37.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 172032, "Other-ver102_38.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 176128, "Other-ver102_39.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 180224, "Other-ver102_40.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 184320, "Other-ver102_41.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 188416, "Other-ver102_42.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 192512, "Other-ver102_43.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 196608, "Other-ver102_44.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 200704, "Other-ver102_45.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 208896, "Other-ver102_46.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 212992, "Other-ver102_47.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 217088, "Other-ver102_48.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 221184, "Other-ver102_49.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 225280, "Other-ver102_50.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 229376, "Other-ver102_51.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 237568, "Other-ver102_52.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 241664, "Other-ver102_53.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 245760, "Other-ver102_54.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 249856, "Other-ver102_55.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 253952, "Other-ver102_56.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 258048, "Other-ver102_57.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 266240, "Other-ver102_58.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 270336, "Other-ver102_59.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 274432, "Other-ver102_60.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 278528, "Other-ver102_61.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 282624, "Other-ver102_62.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 286720, "Other-ver102_63.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 294912, "Other-ver102_64.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 299008, "Other-ver102_65.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 303104, "Other-ver102_66.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 307200, "Other-ver102_67.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 311296, "Other-ver102_68.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 315392, "Other-ver102_69.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 323584, "Other-ver102_70.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 327680, "Other-ver102_71.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 331776, "Other-ver102_72.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 335872, "Other-ver102_73.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 339968, "Other-ver102_74.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 344064, "Other-ver102_75.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 352256, "Other-ver102_76.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 356352, "Other-ver102_77.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 360448, "Other-ver102_78.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 364544, "Other-ver102_79.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 368640, "Other-ver102_80.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 372736, "Other-ver102_81.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 380928, "Other-ver102_82.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 385024, "Other-ver102_83.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 389120, "Other-ver102_84.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 393216, "Other-ver102_85.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 397312, "Other-ver102_86.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 401408, "Other-ver102_87.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 409600, "Other-ver102_88.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 413696, "Other-ver102_89.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 417792, "Other-ver102_90.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 421888, "Other-ver102_91.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 425984, "Other-ver102_92.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 430080, "Other-ver102_93.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 438272, "Other-ver102_94.png"));
        this.artworkItems.add(new ArtworkItem(1, 22, 442368, "Other-ver102_95.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 446464, "Other-ver102_96.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 454656, "Other-ver102_97.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 462848, "Other-ver102_98.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 471040, "Other-ver102_99.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 479232, "Other-ver102_100.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 487424, "Other-ver102_101.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 495616, "Other-ver102_102.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 503808, "Other-ver102_103.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 507904, "Other-ver102_104.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 516096, "Other-ver102_105.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 524288, "Other-ver102_106.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 532480, "Other-ver102_107.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 540672, "Other-ver102_108.png"));
        this.artworkItems.add(new ArtworkItem(280, 2, 548864, "Other-ver102_109.png"));
        this.artworkItems.add(new ArtworkItem(3, 31, 552960, "Other-ver102_110.png"));
        this.artworkItems.add(new ArtworkItem(22, 23, 557056, "Other-ver102_111.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 561152, "Other-ver102_112.png"));
        this.artworkItems.add(new ArtworkItem(1, 49, 565248, "Other-ver102_113.png"));
        this.artworkItems.add(new ArtworkItem(11, 24, 569344, "Other-ver102_114.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 573440, "Other-ver102_115.png"));
        this.artworkItems.add(new ArtworkItem(1, 32, 577536, "Other-ver102_116.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 581632, "Other-ver102_117.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 585728, "Other-ver102_118.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 593920, "Other-ver102_119.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 602112, "Other-ver102_120.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 610304, "Other-ver102_121.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 618496, "Other-ver102_122.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 626688, "Other-ver102_123.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 634880, "Other-ver102_124.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 643072, "Other-ver102_125.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 651264, "Other-ver102_126.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 659456, "Other-ver102_127.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 667648, "Other-ver102_128.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 675840, "Other-ver102_129.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 684032, "Other-ver102_130.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 692224, "Other-ver102_131.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 700416, "Other-ver102_132.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 708608, "Other-ver102_133.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 716800, "Other-ver102_134.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 724992, "Other-ver102_135.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 733184, "Other-ver102_136.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 741376, "Other-ver102_137.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 749568, "Other-ver102_138.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 757760, "Other-ver102_139.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 765952, "Other-ver102_140.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 774144, "Other-ver102_141.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 782336, "Other-ver102_142.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 790528, "Other-ver102_143.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 798720, "Other-ver102_144.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 806912, "Other-ver102_145.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 815104, "Other-ver102_146.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 823296, "Other-ver102_147.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 831488, "Other-ver102_148.png"));
        this.artworkItems.add(new ArtworkItem(18, 19, 839680, "Other-ver102_149.png"));
        this.artworkItems.add(new ArtworkItem(11, 24, 843776, "Other-ver102_150.png"));
        this.artworkItems.add(new ArtworkItem(11, 24, 847872, "Other-ver102_151.png"));
        this.artworkItems.add(new ArtworkItem(16, 17, 851968, "Other-ver102_152.png"));
        this.artworkItems.add(new ArtworkItem(100, 100, 856064, "Other-ver102_153.png"));
        this.artworkItems.add(new ArtworkItem(7, 7, 901120, "Other-ver102_154.png"));
        this.artworkItems.add(new ArtworkItem(18, 19, 905216, "Other-ver102_155.png"));
        this.artworkItems.add(new ArtworkItem(18, 19, 909312, "Other-ver102_156.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 913408, "Other-ver102_157.png"));
        this.artworkItems.add(new ArtworkItem(1, 57, 917504, "Other-ver102_158.png"));
        this.artworkItems.add(new ArtworkItem(41, 70, 921600, "Other-ver102_159.png"));
        this.artworkItems.add(new ArtworkItem(17, 57, 937984, "Other-ver102_160.png"));
        this.artworkItems.add(new ArtworkItem(17, 57, 946176, "Other-ver102_161.png"));
        this.artworkItems.add(new ArtworkItem(41, 70, 954368, "Other-ver102_162.png"));
        this.artworkItems.add(new ArtworkItem(3, 19, 970752, "Other-ver102_163.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 974848, "Other-ver102_164.png"));
        this.artworkItems.add(new ArtworkItem(1, 96, 978944, "Other-ver102_165.png"));
        this.artworkItems.add(new ArtworkItem(13, 16, 983040, "Other-ver102_166.png"));
        this.artworkItems.add(new ArtworkItem(23, 19, 987136, "Other-ver102_167.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 991232, "Other-ver102_168.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 995328, "Other-ver102_169.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 999424, "Other-ver102_170.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1003520, "Other-ver102_171.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 1007616, "Other-ver102_172.png"));
        this.artworkItems.add(new ArtworkItem(1, 74, 1011712, "Other-ver102_173.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 1015808, "Other-ver102_174.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1019904, "Other-ver102_175.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 1024000, "Other-ver102_176.png"));
        this.artworkItems.add(new ArtworkItem(1, 74, 1028096, "Other-ver102_177.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 1032192, "Other-ver102_178.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 1036288, "Other-ver102_179.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1040384, "Other-ver102_180.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 1044480, "Other-ver102_181.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x100000, "Other-ver102_182.png"));
        this.artworkItems.add(new ArtworkItem(1, 74, 0x101000, "Other-ver102_183.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x102000, "Other-ver102_184.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x103000, "Other-ver102_185.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x104000, "Other-ver102_186.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x105000, "Other-ver102_187.png"));
        this.artworkItems.add(new ArtworkItem(6, 6, 0x106000, "Other-ver102_188.png"));
        this.artworkItems.add(new ArtworkItem(6, 6, 0x107000, "Other-ver102_189.png"));
        this.artworkItems.add(new ArtworkItem(62, 52, 0x108000, "Other-ver102_190.png"));
        this.artworkItems.add(new ArtworkItem(11, 53, 0x10C000, "Other-ver102_191.png"));
        this.artworkItems.add(new ArtworkItem(15, 39, 0x10D000, "Other-ver102_192.png"));
        this.artworkItems.add(new ArtworkItem(18, 18, 0x10E000, "Other-ver102_193.png"));
        this.artworkItems.add(new ArtworkItem(1, 180, 0x10F000, "Other-ver102_194.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 0x111000, "Other-ver102_195.png"));
        this.artworkItems.add(new ArtworkItem(15, 180, 0x113000, "Other-ver102_196.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 0x116000, "Other-ver102_197.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 0x11A000, "Other-ver102_198.png"));
        this.artworkItems.add(new ArtworkItem(1, 180, 0x11E000, "Other-ver102_199.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 0x120000, "Other-ver102_200.png"));
        this.artworkItems.add(new ArtworkItem(15, 180, 0x122000, "Other-ver102_201.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 1200128, "Other-ver102_202.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 1216512, "Other-ver102_203.png"));
        this.artworkItems.add(new ArtworkItem(9, 44, 1232896, "Other-ver102_204.png"));
        this.artworkItems.add(new ArtworkItem(1, 48, 1236992, "Other-ver102_205.png"));
        this.artworkItems.add(new ArtworkItem(1, 62, 1241088, "Other-ver102_206.png"));
        this.artworkItems.add(new ArtworkItem(1, 180, 0x130000, "Other-ver102_207.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 1253376, "Other-ver102_208.png"));
        this.artworkItems.add(new ArtworkItem(9, 180, 1261568, "Other-ver102_209.png"));
        this.artworkItems.add(new ArtworkItem(9, 216, 1273856, "Other-ver102_210.png"));
        this.artworkItems.add(new ArtworkItem(7, 1, 1290240, "Other-ver102_211.png"));
        this.artworkItems.add(new ArtworkItem(19, 46, 1294336, "Other-ver102_212.png"));
        this.artworkItems.add(new ArtworkItem(19, 46, 1302528, "Other-ver102_213.png"));
        this.artworkItems.add(new ArtworkItem(11, 14, 0x140000, "Other-ver102_214.png"));
        this.artworkItems.add(new ArtworkItem(284, 62, 0x141000, "Other-ver102_215.png"));
        this.artworkItems.add(new ArtworkItem(11, 43, 1388544, "Other-ver102_216.png"));
        this.artworkItems.add(new ArtworkItem(11, 43, 1392640, "Other-ver102_217.png"));
        this.artworkItems.add(new ArtworkItem(11, 43, 0x155000, "Other-ver102_218.png"));
        this.artworkItems.add(new ArtworkItem(14, 14, 1400832, "Other-ver102_219.png"));
        this.artworkItems.add(new ArtworkItem(13, 44, 1404928, "Other-ver102_220.png"));
        this.artworkItems.add(new ArtworkItem(13, 44, 1409024, "Other-ver102_221.png"));
        this.artworkItems.add(new ArtworkItem(14, 14, 1413120, "Other-ver102_222.png"));
        this.artworkItems.add(new ArtworkItem(15, 11, 1417216, "Other-ver102_223.png"));
        this.artworkItems.add(new ArtworkItem(14, 14, 1421312, "Other-ver102_224.png"));
        this.artworkItems.add(new ArtworkItem(29, 29, 1425408, "Other-ver102_225.png"));
        this.artworkItems.add(new ArtworkItem(13, 3, 1429504, "Other-ver102_226.png"));
        this.artworkItems.add(new ArtworkItem(29, 29, 1433600, "Other-ver102_227.png"));
        this.artworkItems.add(new ArtworkItem(17, 33, 1437696, "Other-ver102_228.png"));
        this.artworkItems.add(new ArtworkItem(17, 33, 0x160000, "Other-ver102_229.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 0x161000, "Other-ver102_230.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 1449984, "Other-ver102_231.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 1454080, "Other-ver102_232.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 1458176, "Other-ver102_233.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 1462272, "Other-ver102_234.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 0x166000, "Other-ver102_235.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 1470464, "Other-ver102_236.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 1474560, "Other-ver102_237.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 1478656, "Other-ver102_238.png"));
        this.artworkItems.add(new ArtworkItem(5, 5, 1482752, "Other-ver102_239.png"));
        this.artworkItems.add(new ArtworkItem(7, 7, 1486848, "Other-ver102_240.png"));
        this.artworkItems.add(new ArtworkItem(5, 5, 1490944, "Other-ver102_241.png"));
        this.artworkItems.add(new ArtworkItem(54, 54, 1495040, "Other-ver102_242.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 0x170000, "Other-ver102_243.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 0x171000, "Other-ver102_244.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 1515520, "Other-ver102_245.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 1519616, "Other-ver102_246.png"));
        this.artworkItems.add(new ArtworkItem(1, 8, 1523712, "Other-ver102_247.png"));
        this.artworkItems.add(new ArtworkItem(4, 8, 1527808, "Other-ver102_248.png"));
        this.artworkItems.add(new ArtworkItem(4, 8, 1531904, "Other-ver102_249.png"));
        this.artworkItems.add(new ArtworkItem(17, 18, 0x177000, "Other-ver102_250.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 1540096, "Other-ver102_251.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 1544192, "Other-ver102_252.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 1548288, "Other-ver102_253.png"));
        this.artworkItems.add(new ArtworkItem(15, 15, 1552384, "Other-ver102_254.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 1556480, "Other-ver102_255.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 1560576, "Other-ver102_256.png"));
        this.artworkItems.add(new ArtworkItem(17, 32, 1564672, "Other-ver102_257.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 1568768, "Other-ver102_258.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 0x180000, "Other-ver102_259.png"));
        this.artworkItems.add(new ArtworkItem(1, 32, 0x181000, "Other-ver102_260.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 1581056, "Other-ver102_261.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 1585152, "Other-ver102_262.png"));
        this.artworkItems.add(new ArtworkItem(17, 32, 1589248, "Other-ver102_263.png"));
        this.artworkItems.add(new ArtworkItem(1, 23, 1593344, "Other-ver102_264.png"));
        this.artworkItems.add(new ArtworkItem(1, 23, 1597440, "Other-ver102_265.png"));
        this.artworkItems.add(new ArtworkItem(8, 10, 1601536, "Other-ver102_266.png"));
        this.artworkItems.add(new ArtworkItem(13, 30, 0x188000, "Other-ver102_267.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 1609728, "Other-ver102_268.png"));
        this.artworkItems.add(new ArtworkItem(6, 30, 1613824, "Other-ver102_269.png"));
        this.artworkItems.add(new ArtworkItem(6, 30, 1617920, "Other-ver102_270.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 1622016, "Other-ver102_271.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 1626112, "Other-ver102_272.png"));
        this.artworkItems.add(new ArtworkItem(21, 44, 1630208, "Other-ver102_273.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 0x190000, "Other-ver102_274.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 0x191000, "Other-ver102_275.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 1646592, "Other-ver102_276.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1650688, "Other-ver102_277.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 1654784, "Other-ver102_278.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 1658880, "Other-ver102_279.png"));
        this.artworkItems.add(new ArtworkItem(21, 44, 1662976, "Other-ver102_280.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1671168, "Other-ver102_281.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 0x199000, "Other-ver102_282.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 1679360, "Other-ver102_283.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1683456, "Other-ver102_284.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 1687552, "Other-ver102_285.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 1691648, "Other-ver102_286.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 1695744, "Other-ver102_287.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 1699840, "Other-ver102_288.png"));
        this.artworkItems.add(new ArtworkItem(23, 23, 0x1A0000, "Other-ver102_289.png"));
        this.artworkItems.add(new ArtworkItem(23, 23, 0x1A1000, "Other-ver102_290.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 1712128, "Other-ver102_291.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 1716224, "Other-ver102_292.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 1720320, "Other-ver102_293.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 1724416, "Other-ver102_294.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 1728512, "Other-ver102_295.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 1732608, "Other-ver102_296.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 1736704, "Other-ver102_297.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 1740800, "Other-ver102_298.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 0x1AA000, "Other-ver102_299.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 1748992, "Other-ver102_300.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 1753088, "Other-ver102_301.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 1757184, "Other-ver102_302.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 1761280, "Other-ver102_303.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 1765376, "Other-ver102_304.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 0x1B0000, "Other-ver102_305.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 0x1B1000, "Other-ver102_306.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 1777664, "Other-ver102_307.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 1781760, "Other-ver102_308.png"));
        this.artworkItems.add(new ArtworkItem(3, 19, 1785856, "Other-ver102_309.png"));
        this.artworkItems.add(new ArtworkItem(3, 19, 1789952, "Other-ver102_310.png"));
        this.artworkItems.add(new ArtworkItem(19, 17, 1794048, "Other-ver102_311.png"));
        this.artworkItems.add(new ArtworkItem(10, 13, 1798144, "Other-ver102_312.png"));
        this.artworkItems.add(new ArtworkItem(29, 31, 1802240, "Other-ver102_313.png"));
        this.artworkItems.add(new ArtworkItem(29, 31, 1806336, "Other-ver102_314.png"));
        this.artworkItems.add(new ArtworkItem(10, 13, 1810432, "Other-ver102_315.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 0x1BB000, "Other-ver102_316.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 1818624, "Other-ver102_317.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 1822720, "Other-ver102_318.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 1826816, "Other-ver102_319.png"));
        this.artworkItems.add(new ArtworkItem(19, 19, 1830912, "Other-ver102_320.png"));
        this.artworkItems.add(new ArtworkItem(19, 19, 0x1C0000, "Other-ver102_321.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 0x1C1000, "Other-ver102_322.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 1847296, "Other-ver102_323.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 1863680, "Other-ver102_324.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 1871872, "Other-ver102_325.png"));
        this.artworkItems.add(new ArtworkItem(9, 44, 1888256, "Other-ver102_326.png"));
        this.artworkItems.add(new ArtworkItem(1, 48, 1892352, "Other-ver102_327.png"));
        this.artworkItems.add(new ArtworkItem(1, 62, 1896448, "Other-ver102_328.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 0x1D0000, "Other-ver102_329.png"));
        this.artworkItems.add(new ArtworkItem(9, 216, 1908736, "Other-ver102_330.png"));
        this.artworkItems.add(new ArtworkItem(13, 13, 1925120, "Other-ver102_331.png"));
    }

    private void initKeyboard_Common_ver102() {
        this.artworkItems = new Vector(11);
        this.artworkItems.add(new ArtworkItem(148, 148, 0, "Keyboard_Common-ver102_0.png"));
        this.artworkItems.add(new ArtworkItem(148, 148, 90112, "Keyboard_Common-ver102_1.png"));
        this.artworkItems.add(new ArtworkItem(8, 8, 180224, "Keyboard_Common-ver102_2.png"));
        this.artworkItems.add(new ArtworkItem(16, 31, 184320, "Keyboard_Common-ver102_3.png"));
        this.artworkItems.add(new ArtworkItem(16, 31, 188416, "Keyboard_Common-ver102_4.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 192512, "Keyboard_Common-ver102_5.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 196608, "Keyboard_Common-ver102_6.png"));
        this.artworkItems.add(new ArtworkItem(127, 127, 200704, "Keyboard_Common-ver102_7.png"));
        this.artworkItems.add(new ArtworkItem(127, 127, 266240, "Keyboard_Common-ver102_8.png"));
        this.artworkItems.add(new ArtworkItem(127, 127, 331776, "Keyboard_Common-ver102_9.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 397312, "Keyboard_Common-ver102_10.png"));
    }

    private void initKeyboard_StandardQWERTY_ver102() {
        this.artworkItems = new Vector(107);
        this.artworkItems.add(new ArtworkItem(320, 216, 0, "Keyboard_StandardQWERTY-ver102_0.png"));
        this.artworkItems.add(new ArtworkItem(83, 120, 278528, "Keyboard_StandardQWERTY-ver102_1.png"));
        this.artworkItems.add(new ArtworkItem(91, 120, 323584, "Keyboard_StandardQWERTY-ver102_2.png"));
        this.artworkItems.add(new ArtworkItem(88, 120, 372736, "Keyboard_StandardQWERTY-ver102_3.png"));
        this.artworkItems.add(new ArtworkItem(79, 120, 417792, "Keyboard_StandardQWERTY-ver102_4.png"));
        this.artworkItems.add(new ArtworkItem(114, 125, 458752, "Keyboard_StandardQWERTY-ver102_5.png"));
        this.artworkItems.add(new ArtworkItem(79, 126, 520192, "Keyboard_StandardQWERTY-ver102_6.png"));
        this.artworkItems.add(new ArtworkItem(78, 126, 561152, "Keyboard_StandardQWERTY-ver102_7.png"));
        this.artworkItems.add(new ArtworkItem(220, 500, 602112, "Keyboard_StandardQWERTY-ver102_8.png"));
        this.artworkItems.add(new ArtworkItem(88, 750, 0x101000, "Keyboard_StandardQWERTY-ver102_9.png"));
        this.artworkItems.add(new ArtworkItem(88, 750, 1318912, "Keyboard_StandardQWERTY-ver102_10.png"));
        this.artworkItems.add(new ArtworkItem(176, 500, 1585152, "Keyboard_StandardQWERTY-ver102_11.png"));
        this.artworkItems.add(new ArtworkItem(132, 500, 1937408, "Keyboard_StandardQWERTY-ver102_12.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 2211840, "Keyboard_StandardQWERTY-ver102_13.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 2560000, "Keyboard_StandardQWERTY-ver102_14.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 2908160, "Keyboard_StandardQWERTY-ver102_15.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x30A000, "Keyboard_StandardQWERTY-ver102_16.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 3465216, "Keyboard_StandardQWERTY-ver102_17.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 3743744, "Keyboard_StandardQWERTY-ver102_18.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 4022272, "Keyboard_StandardQWERTY-ver102_19.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 4300800, "Keyboard_StandardQWERTY-ver102_20.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 4579328, "Keyboard_StandardQWERTY-ver102_21.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 4857856, "Keyboard_StandardQWERTY-ver102_22.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 5136384, "Keyboard_StandardQWERTY-ver102_23.png"));
        this.artworkItems.add(new ArtworkItem(103, 120, 5484544, "Keyboard_StandardQWERTY-ver102_24.png"));
        this.artworkItems.add(new ArtworkItem(115, 120, 5537792, "Keyboard_StandardQWERTY-ver102_25.png"));
        this.artworkItems.add(new ArtworkItem(126, 120, 0x557000, "Keyboard_StandardQWERTY-ver102_26.png"));
        this.artworkItems.add(new ArtworkItem(99, 120, 0x566000, "Keyboard_StandardQWERTY-ver102_27.png"));
        this.artworkItems.add(new ArtworkItem(110, 126, 5713920, "Keyboard_StandardQWERTY-ver102_28.png"));
        this.artworkItems.add(new ArtworkItem(85, 126, 5771264, "Keyboard_StandardQWERTY-ver102_29.png"));
        this.artworkItems.add(new ArtworkItem(85, 126, 5816320, "Keyboard_StandardQWERTY-ver102_30.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 5861376, "Keyboard_StandardQWERTY-ver102_31.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 5881856, "Keyboard_StandardQWERTY-ver102_32.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 5902336, "Keyboard_StandardQWERTY-ver102_33.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 5922816, "Keyboard_StandardQWERTY-ver102_34.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 5943296, "Keyboard_StandardQWERTY-ver102_35.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 0x5B0000, "Keyboard_StandardQWERTY-ver102_36.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 0x5B5000, "Keyboard_StandardQWERTY-ver102_37.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 6004736, "Keyboard_StandardQWERTY-ver102_38.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 6025216, "Keyboard_StandardQWERTY-ver102_39.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 6045696, "Keyboard_StandardQWERTY-ver102_40.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 6066176, "Keyboard_StandardQWERTY-ver102_41.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 6086656, "Keyboard_StandardQWERTY-ver102_42.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 6107136, "Keyboard_StandardQWERTY-ver102_43.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 6127616, "Keyboard_StandardQWERTY-ver102_44.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 0x5DD000, "Keyboard_StandardQWERTY-ver102_45.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 6168576, "Keyboard_StandardQWERTY-ver102_46.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 6189056, "Keyboard_StandardQWERTY-ver102_47.png"));
        this.artworkItems.add(new ArtworkItem(98, 44, 6209536, "Keyboard_StandardQWERTY-ver102_48.png"));
        this.artworkItems.add(new ArtworkItem(76, 45, 6230016, "Keyboard_StandardQWERTY-ver102_49.png"));
        this.artworkItems.add(new ArtworkItem(76, 45, 0x5F5000, "Keyboard_StandardQWERTY-ver102_50.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 6262784, "Keyboard_StandardQWERTY-ver102_51.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 6610944, "Keyboard_StandardQWERTY-ver102_52.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 6889472, "Keyboard_StandardQWERTY-ver102_53.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x6D6000, "Keyboard_StandardQWERTY-ver102_54.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 7446528, "Keyboard_StandardQWERTY-ver102_55.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 7725056, "Keyboard_StandardQWERTY-ver102_56.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 8003584, "Keyboard_StandardQWERTY-ver102_57.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 8282112, "Keyboard_StandardQWERTY-ver102_58.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 8560640, "Keyboard_StandardQWERTY-ver102_59.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 8839168, "Keyboard_StandardQWERTY-ver102_60.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 8855552, "Keyboard_StandardQWERTY-ver102_61.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 8871936, "Keyboard_StandardQWERTY-ver102_62.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 8888320, "Keyboard_StandardQWERTY-ver102_63.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 8904704, "Keyboard_StandardQWERTY-ver102_64.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 0x882000, "Keyboard_StandardQWERTY-ver102_65.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 0x886000, "Keyboard_StandardQWERTY-ver102_66.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 0x88A000, "Keyboard_StandardQWERTY-ver102_67.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 0x88E000, "Keyboard_StandardQWERTY-ver102_68.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 8986624, "Keyboard_StandardQWERTY-ver102_69.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9003008, "Keyboard_StandardQWERTY-ver102_70.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9019392, "Keyboard_StandardQWERTY-ver102_71.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9035776, "Keyboard_StandardQWERTY-ver102_72.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9052160, "Keyboard_StandardQWERTY-ver102_73.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9068544, "Keyboard_StandardQWERTY-ver102_74.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 0x8AA000, "Keyboard_StandardQWERTY-ver102_75.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9101312, "Keyboard_StandardQWERTY-ver102_76.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9117696, "Keyboard_StandardQWERTY-ver102_77.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9134080, "Keyboard_StandardQWERTY-ver102_78.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9150464, "Keyboard_StandardQWERTY-ver102_79.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9166848, "Keyboard_StandardQWERTY-ver102_80.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9183232, "Keyboard_StandardQWERTY-ver102_81.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9199616, "Keyboard_StandardQWERTY-ver102_82.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9216000, "Keyboard_StandardQWERTY-ver102_83.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9232384, "Keyboard_StandardQWERTY-ver102_84.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9248768, "Keyboard_StandardQWERTY-ver102_85.png"));
        this.artworkItems.add(new ArtworkItem(80, 46, 9265152, "Keyboard_StandardQWERTY-ver102_86.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 9281536, "Keyboard_StandardQWERTY-ver102_87.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 9289728, "Keyboard_StandardQWERTY-ver102_88.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 9297920, "Keyboard_StandardQWERTY-ver102_89.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 0x8E0000, "Keyboard_StandardQWERTY-ver102_90.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 9314304, "Keyboard_StandardQWERTY-ver102_91.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 9592832, "Keyboard_StandardQWERTY-ver102_92.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 9871360, "Keyboard_StandardQWERTY-ver102_93.png"));
        this.artworkItems.add(new ArtworkItem(4, 36, 10149888, "Keyboard_StandardQWERTY-ver102_94.png"));
        this.artworkItems.add(new ArtworkItem(4, 36, 10153984, "Keyboard_StandardQWERTY-ver102_95.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x9B0000, "Keyboard_StandardQWERTY-ver102_96.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 10436608, "Keyboard_StandardQWERTY-ver102_97.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 10715136, "Keyboard_StandardQWERTY-ver102_98.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 10993664, "Keyboard_StandardQWERTY-ver102_99.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 11341824, "Keyboard_StandardQWERTY-ver102_100.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 11689984, "Keyboard_StandardQWERTY-ver102_101.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 11968512, "Keyboard_StandardQWERTY-ver102_102.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 12247040, "Keyboard_StandardQWERTY-ver102_103.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 0xC03000, "Keyboard_StandardQWERTY-ver102_104.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 12943360, "Keyboard_StandardQWERTY-ver102_105.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0xC9C000, "Keyboard_StandardQWERTY-ver102_106.png"));
    }

    private void initOther_ver111() {
        this.artworkItems = new Vector(341);
        this.artworkItems.add(new ArtworkItem(16, 20, 0, "Other-ver111_0.png"));
        this.artworkItems.add(new ArtworkItem(16, 20, 4096, "Other-ver111_1.png"));
        this.artworkItems.add(new ArtworkItem(320, 480, 8192, "Other-ver111_2.png"));
        this.artworkItems.add(new ArtworkItem(320, 480, 622592, "Other-ver111_3.png"));
        this.artworkItems.add(new ArtworkItem(1, 222, 1236992, "Other-ver111_4.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 0x130000, "Other-ver111_5.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 0x131000, "Other-ver111_6.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 1253376, "Other-ver111_7.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 0x133000, "Other-ver111_8.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 1261568, "Other-ver111_9.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 1265664, "Other-ver111_10.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 1269760, "Other-ver111_11.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 1273856, "Other-ver111_12.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1277952, "Other-ver111_13.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1282048, "Other-ver111_14.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1286144, "Other-ver111_15.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1290240, "Other-ver111_16.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1294336, "Other-ver111_17.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1302528, "Other-ver111_18.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1306624, "Other-ver111_19.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 0x140000, "Other-ver111_20.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x141000, "Other-ver111_21.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1318912, "Other-ver111_22.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1323008, "Other-ver111_23.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1331200, "Other-ver111_24.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1335296, "Other-ver111_25.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1339392, "Other-ver111_26.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1343488, "Other-ver111_27.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1347584, "Other-ver111_28.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1351680, "Other-ver111_29.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1359872, "Other-ver111_30.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1363968, "Other-ver111_31.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1368064, "Other-ver111_32.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1372160, "Other-ver111_33.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x150000, "Other-ver111_34.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x151000, "Other-ver111_35.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1384448, "Other-ver111_36.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1388544, "Other-ver111_37.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1392640, "Other-ver111_38.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x155000, "Other-ver111_39.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1400832, "Other-ver111_40.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1404928, "Other-ver111_41.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1409024, "Other-ver111_42.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1413120, "Other-ver111_43.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1417216, "Other-ver111_44.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1421312, "Other-ver111_45.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1425408, "Other-ver111_46.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1429504, "Other-ver111_47.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1437696, "Other-ver111_48.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x160000, "Other-ver111_49.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 0x161000, "Other-ver111_50.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1449984, "Other-ver111_51.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1454080, "Other-ver111_52.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1458176, "Other-ver111_53.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x166000, "Other-ver111_54.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1470464, "Other-ver111_55.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1474560, "Other-ver111_56.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1478656, "Other-ver111_57.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1482752, "Other-ver111_58.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1486848, "Other-ver111_59.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1495040, "Other-ver111_60.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1499136, "Other-ver111_61.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1503232, "Other-ver111_62.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x170000, "Other-ver111_63.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 0x171000, "Other-ver111_64.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1515520, "Other-ver111_65.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1523712, "Other-ver111_66.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1527808, "Other-ver111_67.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1531904, "Other-ver111_68.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x177000, "Other-ver111_69.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1540096, "Other-ver111_70.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1544192, "Other-ver111_71.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1552384, "Other-ver111_72.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1556480, "Other-ver111_73.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1560576, "Other-ver111_74.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1564672, "Other-ver111_75.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1568768, "Other-ver111_76.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 0x180000, "Other-ver111_77.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1581056, "Other-ver111_78.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1585152, "Other-ver111_79.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1589248, "Other-ver111_80.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1593344, "Other-ver111_81.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1597440, "Other-ver111_82.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1601536, "Other-ver111_83.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1609728, "Other-ver111_84.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1613824, "Other-ver111_85.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1617920, "Other-ver111_86.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1622016, "Other-ver111_87.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1626112, "Other-ver111_88.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1630208, "Other-ver111_89.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x190000, "Other-ver111_90.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x191000, "Other-ver111_91.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1646592, "Other-ver111_92.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1650688, "Other-ver111_93.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1654784, "Other-ver111_94.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1658880, "Other-ver111_95.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1667072, "Other-ver111_96.png"));
        this.artworkItems.add(new ArtworkItem(1, 22, 1671168, "Other-ver111_97.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 0x199000, "Other-ver111_98.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 1683456, "Other-ver111_99.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 1691648, "Other-ver111_100.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 1699840, "Other-ver111_101.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 0x1A1000, "Other-ver111_102.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 1716224, "Other-ver111_103.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 1724416, "Other-ver111_104.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1732608, "Other-ver111_105.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 1736704, "Other-ver111_106.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 0x1AA000, "Other-ver111_107.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 1753088, "Other-ver111_108.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 1761280, "Other-ver111_109.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 0x1B0000, "Other-ver111_110.png"));
        this.artworkItems.add(new ArtworkItem(280, 2, 1777664, "Other-ver111_111.png"));
        this.artworkItems.add(new ArtworkItem(3, 31, 1781760, "Other-ver111_112.png"));
        this.artworkItems.add(new ArtworkItem(22, 23, 1785856, "Other-ver111_113.png"));
        this.artworkItems.add(new ArtworkItem(27, 28, 1789952, "Other-ver111_114.png"));
        this.artworkItems.add(new ArtworkItem(27, 28, 1794048, "Other-ver111_115.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1798144, "Other-ver111_116.png"));
        this.artworkItems.add(new ArtworkItem(1, 49, 1802240, "Other-ver111_117.png"));
        this.artworkItems.add(new ArtworkItem(11, 24, 1806336, "Other-ver111_118.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1810432, "Other-ver111_119.png"));
        this.artworkItems.add(new ArtworkItem(1, 32, 0x1BB000, "Other-ver111_120.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1818624, "Other-ver111_121.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1822720, "Other-ver111_122.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1830912, "Other-ver111_123.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 0x1C1000, "Other-ver111_124.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1847296, "Other-ver111_125.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1855488, "Other-ver111_126.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1863680, "Other-ver111_127.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1871872, "Other-ver111_128.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1880064, "Other-ver111_129.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1888256, "Other-ver111_130.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1896448, "Other-ver111_131.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 0x1D1000, "Other-ver111_132.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1912832, "Other-ver111_133.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1921024, "Other-ver111_134.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1929216, "Other-ver111_135.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1937408, "Other-ver111_136.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1945600, "Other-ver111_137.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 0x1DD000, "Other-ver111_138.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1961984, "Other-ver111_139.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 0x1E1000, "Other-ver111_140.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1978368, "Other-ver111_141.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1986560, "Other-ver111_142.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1994752, "Other-ver111_143.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2002944, "Other-ver111_144.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2011136, "Other-ver111_145.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2019328, "Other-ver111_146.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2027520, "Other-ver111_147.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 0x1F1000, "Other-ver111_148.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2043904, "Other-ver111_149.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2052096, "Other-ver111_150.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2060288, "Other-ver111_151.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2068480, "Other-ver111_152.png"));
        this.artworkItems.add(new ArtworkItem(18, 19, 2076672, "Other-ver111_153.png"));
        this.artworkItems.add(new ArtworkItem(11, 24, 2080768, "Other-ver111_154.png"));
        this.artworkItems.add(new ArtworkItem(11, 24, 2084864, "Other-ver111_155.png"));
        this.artworkItems.add(new ArtworkItem(16, 17, 2088960, "Other-ver111_156.png"));
        this.artworkItems.add(new ArtworkItem(100, 100, 0x1FF000, "Other-ver111_157.png"));
        this.artworkItems.add(new ArtworkItem(7, 7, 0x20A000, "Other-ver111_158.png"));
        this.artworkItems.add(new ArtworkItem(18, 19, 0x20B000, "Other-ver111_159.png"));
        this.artworkItems.add(new ArtworkItem(18, 19, 0x20C000, "Other-ver111_160.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 0x20D000, "Other-ver111_161.png"));
        this.artworkItems.add(new ArtworkItem(1, 57, 0x20E000, "Other-ver111_162.png"));
        this.artworkItems.add(new ArtworkItem(41, 70, 0x20F000, "Other-ver111_163.png"));
        this.artworkItems.add(new ArtworkItem(17, 57, 2174976, "Other-ver111_164.png"));
        this.artworkItems.add(new ArtworkItem(17, 57, 2183168, "Other-ver111_165.png"));
        this.artworkItems.add(new ArtworkItem(41, 70, 2191360, "Other-ver111_166.png"));
        this.artworkItems.add(new ArtworkItem(3, 19, 2207744, "Other-ver111_167.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 2211840, "Other-ver111_168.png"));
        this.artworkItems.add(new ArtworkItem(1, 96, 2215936, "Other-ver111_169.png"));
        this.artworkItems.add(new ArtworkItem(13, 16, 2220032, "Other-ver111_170.png"));
        this.artworkItems.add(new ArtworkItem(23, 19, 2224128, "Other-ver111_171.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 0x220000, "Other-ver111_172.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x221000, "Other-ver111_173.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 0x222000, "Other-ver111_174.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 0x223000, "Other-ver111_175.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x224000, "Other-ver111_176.png"));
        this.artworkItems.add(new ArtworkItem(1, 74, 0x225000, "Other-ver111_177.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 0x226000, "Other-ver111_178.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 0x227000, "Other-ver111_179.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x228000, "Other-ver111_180.png"));
        this.artworkItems.add(new ArtworkItem(1, 74, 0x229000, "Other-ver111_181.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 0x22A000, "Other-ver111_182.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 0x22B000, "Other-ver111_183.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 0x22C000, "Other-ver111_184.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x22D000, "Other-ver111_185.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x22E000, "Other-ver111_186.png"));
        this.artworkItems.add(new ArtworkItem(1, 74, 0x22F000, "Other-ver111_187.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x230000, "Other-ver111_188.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 2297856, "Other-ver111_189.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x232000, "Other-ver111_190.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x233000, "Other-ver111_191.png"));
        this.artworkItems.add(new ArtworkItem(6, 6, 2310144, "Other-ver111_192.png"));
        this.artworkItems.add(new ArtworkItem(6, 6, 2314240, "Other-ver111_193.png"));
        this.artworkItems.add(new ArtworkItem(62, 52, 2318336, "Other-ver111_194.png"));
        this.artworkItems.add(new ArtworkItem(11, 53, 2334720, "Other-ver111_195.png"));
        this.artworkItems.add(new ArtworkItem(15, 39, 2338816, "Other-ver111_196.png"));
        this.artworkItems.add(new ArtworkItem(18, 18, 2342912, "Other-ver111_197.png"));
        this.artworkItems.add(new ArtworkItem(1, 180, 2347008, "Other-ver111_198.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 2355200, "Other-ver111_199.png"));
        this.artworkItems.add(new ArtworkItem(15, 180, 2363392, "Other-ver111_200.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 0x244000, "Other-ver111_201.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 2392064, "Other-ver111_202.png"));
        this.artworkItems.add(new ArtworkItem(1, 180, 2408448, "Other-ver111_203.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 2416640, "Other-ver111_204.png"));
        this.artworkItems.add(new ArtworkItem(15, 180, 0x250000, "Other-ver111_205.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 2437120, "Other-ver111_206.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 2453504, "Other-ver111_207.png"));
        this.artworkItems.add(new ArtworkItem(9, 44, 2469888, "Other-ver111_208.png"));
        this.artworkItems.add(new ArtworkItem(1, 48, 2473984, "Other-ver111_209.png"));
        this.artworkItems.add(new ArtworkItem(1, 62, 2478080, "Other-ver111_210.png"));
        this.artworkItems.add(new ArtworkItem(1, 180, 2482176, "Other-ver111_211.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 0x260000, "Other-ver111_212.png"));
        this.artworkItems.add(new ArtworkItem(9, 180, 0x262000, "Other-ver111_213.png"));
        this.artworkItems.add(new ArtworkItem(9, 216, 2510848, "Other-ver111_214.png"));
        this.artworkItems.add(new ArtworkItem(7, 1, 2527232, "Other-ver111_215.png"));
        this.artworkItems.add(new ArtworkItem(19, 46, 2531328, "Other-ver111_216.png"));
        this.artworkItems.add(new ArtworkItem(19, 46, 2539520, "Other-ver111_217.png"));
        this.artworkItems.add(new ArtworkItem(11, 14, 2547712, "Other-ver111_218.png"));
        this.artworkItems.add(new ArtworkItem(284, 62, 2551808, "Other-ver111_219.png"));
        this.artworkItems.add(new ArtworkItem(11, 43, 2625536, "Other-ver111_220.png"));
        this.artworkItems.add(new ArtworkItem(11, 43, 0x282000, "Other-ver111_221.png"));
        this.artworkItems.add(new ArtworkItem(11, 43, 2633728, "Other-ver111_222.png"));
        this.artworkItems.add(new ArtworkItem(14, 14, 2637824, "Other-ver111_223.png"));
        this.artworkItems.add(new ArtworkItem(13, 44, 2641920, "Other-ver111_224.png"));
        this.artworkItems.add(new ArtworkItem(13, 44, 2646016, "Other-ver111_225.png"));
        this.artworkItems.add(new ArtworkItem(14, 14, 2650112, "Other-ver111_226.png"));
        this.artworkItems.add(new ArtworkItem(15, 11, 0x288000, "Other-ver111_227.png"));
        this.artworkItems.add(new ArtworkItem(14, 14, 2658304, "Other-ver111_228.png"));
        this.artworkItems.add(new ArtworkItem(29, 29, 2662400, "Other-ver111_229.png"));
        this.artworkItems.add(new ArtworkItem(13, 3, 2666496, "Other-ver111_230.png"));
        this.artworkItems.add(new ArtworkItem(29, 29, 2670592, "Other-ver111_231.png"));
        this.artworkItems.add(new ArtworkItem(17, 33, 2674688, "Other-ver111_232.png"));
        this.artworkItems.add(new ArtworkItem(17, 33, 2678784, "Other-ver111_233.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 2682880, "Other-ver111_234.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 0x290000, "Other-ver111_235.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 2691072, "Other-ver111_236.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 0x292000, "Other-ver111_237.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 2699264, "Other-ver111_238.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 2703360, "Other-ver111_239.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 2707456, "Other-ver111_240.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 2711552, "Other-ver111_241.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 2715648, "Other-ver111_242.png"));
        this.artworkItems.add(new ArtworkItem(5, 5, 2719744, "Other-ver111_243.png"));
        this.artworkItems.add(new ArtworkItem(7, 7, 0x299000, "Other-ver111_244.png"));
        this.artworkItems.add(new ArtworkItem(5, 5, 2727936, "Other-ver111_245.png"));
        this.artworkItems.add(new ArtworkItem(54, 54, 2732032, "Other-ver111_246.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 2744320, "Other-ver111_247.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 2748416, "Other-ver111_248.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 0x2A0000, "Other-ver111_249.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 2756608, "Other-ver111_250.png"));
        this.artworkItems.add(new ArtworkItem(1, 8, 0x2A2000, "Other-ver111_251.png"));
        this.artworkItems.add(new ArtworkItem(4, 8, 2764800, "Other-ver111_252.png"));
        this.artworkItems.add(new ArtworkItem(4, 8, 2768896, "Other-ver111_253.png"));
        this.artworkItems.add(new ArtworkItem(17, 18, 2772992, "Other-ver111_254.png"));
        this.artworkItems.add(new ArtworkItem(22, 24, 2777088, "Other-ver111_255.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 2781184, "Other-ver111_256.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 2785280, "Other-ver111_257.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 2789376, "Other-ver111_258.png"));
        this.artworkItems.add(new ArtworkItem(15, 15, 0x2AA000, "Other-ver111_259.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 2797568, "Other-ver111_260.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 2801664, "Other-ver111_261.png"));
        this.artworkItems.add(new ArtworkItem(17, 32, 2805760, "Other-ver111_262.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 2809856, "Other-ver111_263.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 2813952, "Other-ver111_264.png"));
        this.artworkItems.add(new ArtworkItem(1, 32, 0x2B0000, "Other-ver111_265.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 2822144, "Other-ver111_266.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 0x2B2000, "Other-ver111_267.png"));
        this.artworkItems.add(new ArtworkItem(17, 32, 2830336, "Other-ver111_268.png"));
        this.artworkItems.add(new ArtworkItem(1, 23, 2834432, "Other-ver111_269.png"));
        this.artworkItems.add(new ArtworkItem(1, 23, 2838528, "Other-ver111_270.png"));
        this.artworkItems.add(new ArtworkItem(8, 10, 2842624, "Other-ver111_271.png"));
        this.artworkItems.add(new ArtworkItem(13, 30, 2846720, "Other-ver111_272.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 2850816, "Other-ver111_273.png"));
        this.artworkItems.add(new ArtworkItem(6, 30, 2854912, "Other-ver111_274.png"));
        this.artworkItems.add(new ArtworkItem(6, 30, 2859008, "Other-ver111_275.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 0x2BB000, "Other-ver111_276.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 2867200, "Other-ver111_277.png"));
        this.artworkItems.add(new ArtworkItem(21, 44, 2871296, "Other-ver111_278.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 2879488, "Other-ver111_279.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 0x2C0000, "Other-ver111_280.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 2887680, "Other-ver111_281.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 0x2C2000, "Other-ver111_282.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 2895872, "Other-ver111_283.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 2899968, "Other-ver111_284.png"));
        this.artworkItems.add(new ArtworkItem(21, 44, 2904064, "Other-ver111_285.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 2912256, "Other-ver111_286.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 2916352, "Other-ver111_287.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 2920448, "Other-ver111_288.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 2924544, "Other-ver111_289.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 2928640, "Other-ver111_290.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 0x2CC000, "Other-ver111_291.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 2936832, "Other-ver111_292.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 2940928, "Other-ver111_293.png"));
        this.artworkItems.add(new ArtworkItem(23, 23, 2945024, "Other-ver111_294.png"));
        this.artworkItems.add(new ArtworkItem(23, 23, 0x2D0000, "Other-ver111_295.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 2953216, "Other-ver111_296.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 0x2D2000, "Other-ver111_297.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 2961408, "Other-ver111_298.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 2965504, "Other-ver111_299.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 2969600, "Other-ver111_300.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 2973696, "Other-ver111_301.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 2977792, "Other-ver111_302.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 2981888, "Other-ver111_303.png"));
        this.artworkItems.add(new ArtworkItem(14, 16, 2985984, "Other-ver111_304.png"));
        this.artworkItems.add(new ArtworkItem(2, 16, 2990080, "Other-ver111_305.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 2994176, "Other-ver111_306.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 2998272, "Other-ver111_307.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 0x2DD000, "Other-ver111_308.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 3006464, "Other-ver111_309.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 3010560, "Other-ver111_310.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 0x2E0000, "Other-ver111_311.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 3018752, "Other-ver111_312.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 0x2E2000, "Other-ver111_313.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 3026944, "Other-ver111_314.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 3031040, "Other-ver111_315.png"));
        this.artworkItems.add(new ArtworkItem(3, 19, 3035136, "Other-ver111_316.png"));
        this.artworkItems.add(new ArtworkItem(3, 19, 3039232, "Other-ver111_317.png"));
        this.artworkItems.add(new ArtworkItem(19, 17, 3043328, "Other-ver111_318.png"));
        this.artworkItems.add(new ArtworkItem(10, 13, 3047424, "Other-ver111_319.png"));
        this.artworkItems.add(new ArtworkItem(29, 31, 3051520, "Other-ver111_320.png"));
        this.artworkItems.add(new ArtworkItem(29, 31, 3055616, "Other-ver111_321.png"));
        this.artworkItems.add(new ArtworkItem(10, 13, 3059712, "Other-ver111_322.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 3063808, "Other-ver111_323.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 3067904, "Other-ver111_324.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 0x2EE000, "Other-ver111_325.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 3076096, "Other-ver111_326.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 0x2F0000, "Other-ver111_327.png"));
        this.artworkItems.add(new ArtworkItem(19, 19, 3084288, "Other-ver111_328.png"));
        this.artworkItems.add(new ArtworkItem(19, 19, 0x2F2000, "Other-ver111_329.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 3092480, "Other-ver111_330.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 3100672, "Other-ver111_331.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 3117056, "Other-ver111_332.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 3125248, "Other-ver111_333.png"));
        this.artworkItems.add(new ArtworkItem(9, 44, 0x2FF000, "Other-ver111_334.png"));
        this.artworkItems.add(new ArtworkItem(1, 48, 0x300000, "Other-ver111_335.png"));
        this.artworkItems.add(new ArtworkItem(1, 62, 0x301000, "Other-ver111_336.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 0x302000, "Other-ver111_337.png"));
        this.artworkItems.add(new ArtworkItem(9, 216, 0x304000, "Other-ver111_338.png"));
        this.artworkItems.add(new ArtworkItem(13, 13, 0x308000, "Other-ver111_339.png"));
        this.artworkItems.add(new ArtworkItem(24, 26, 0x309000, "Other-ver111_340.png"));
    }

    private void initKeyboard_Japanese_ver111() {
        this.artworkItems = new Vector(46);
        this.artworkItems.add(new ArtworkItem(80, 29, 0, "Keyboard_Japanese-ver111_0.png"));
        this.artworkItems.add(new ArtworkItem(43, 29, 12288, "Keyboard_Japanese-ver111_1.png"));
        this.artworkItems.add(new ArtworkItem(43, 28, 20480, "Keyboard_Japanese-ver111_2.png"));
        this.artworkItems.add(new ArtworkItem(80, 29, 28672, "Keyboard_Japanese-ver111_3.png"));
        this.artworkItems.add(new ArtworkItem(43, 29, 40960, "Keyboard_Japanese-ver111_4.png"));
        this.artworkItems.add(new ArtworkItem(43, 29, 49152, "Keyboard_Japanese-ver111_5.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 57344, "Keyboard_Japanese-ver111_6.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 69632, "Keyboard_Japanese-ver111_7.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 81920, "Keyboard_Japanese-ver111_8.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 94208, "Keyboard_Japanese-ver111_9.png"));
        this.artworkItems.add(new ArtworkItem(36, 32, 106496, "Keyboard_Japanese-ver111_10.png"));
        this.artworkItems.add(new ArtworkItem(41, 36, 114688, "Keyboard_Japanese-ver111_11.png"));
        this.artworkItems.add(new ArtworkItem(37, 29, 122880, "Keyboard_Japanese-ver111_12.png"));
        this.artworkItems.add(new ArtworkItem(37, 28, 131072, "Keyboard_Japanese-ver111_13.png"));
        this.artworkItems.add(new ArtworkItem(37, 29, 139264, "Keyboard_Japanese-ver111_14.png"));
        this.artworkItems.add(new ArtworkItem(37, 28, 147456, "Keyboard_Japanese-ver111_15.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 155648, "Keyboard_Japanese-ver111_16.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 167936, "Keyboard_Japanese-ver111_17.png"));
        this.artworkItems.add(new ArtworkItem(74, 23, 180224, "Keyboard_Japanese-ver111_18.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 188416, "Keyboard_Japanese-ver111_19.png"));
        this.artworkItems.add(new ArtworkItem(74, 23, 200704, "Keyboard_Japanese-ver111_20.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 208896, "Keyboard_Japanese-ver111_21.png"));
        this.artworkItems.add(new ArtworkItem(13, 26, 221184, "Keyboard_Japanese-ver111_22.png"));
        this.artworkItems.add(new ArtworkItem(13, 26, 225280, "Keyboard_Japanese-ver111_23.png"));
        this.artworkItems.add(new ArtworkItem(1, 26, 229376, "Keyboard_Japanese-ver111_24.png"));
        this.artworkItems.add(new ArtworkItem(1, 26, 233472, "Keyboard_Japanese-ver111_25.png"));
        this.artworkItems.add(new ArtworkItem(7, 11, 237568, "Keyboard_Japanese-ver111_26.png"));
        this.artworkItems.add(new ArtworkItem(17, 66, 241664, "Keyboard_Japanese-ver111_27.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 249856, "Keyboard_Japanese-ver111_28.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 528384, "Keyboard_Japanese-ver111_29.png"));
        this.artworkItems.add(new ArtworkItem(7, 11, 806912, "Keyboard_Japanese-ver111_30.png"));
        this.artworkItems.add(new ArtworkItem(17, 66, 811008, "Keyboard_Japanese-ver111_31.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 819200, "Keyboard_Japanese-ver111_32.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x10C000, "Keyboard_Japanese-ver111_33.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x150000, "Keyboard_Japanese-ver111_34.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 1654784, "Keyboard_Japanese-ver111_35.png"));
        this.artworkItems.add(new ArtworkItem(74, 23, 1933312, "Keyboard_Japanese-ver111_36.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 1941504, "Keyboard_Japanese-ver111_37.png"));
        this.artworkItems.add(new ArtworkItem(13, 26, 0x1DD000, "Keyboard_Japanese-ver111_38.png"));
        this.artworkItems.add(new ArtworkItem(13, 26, 1957888, "Keyboard_Japanese-ver111_39.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 1961984, "Keyboard_Japanese-ver111_40.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 1974272, "Keyboard_Japanese-ver111_41.png"));
        this.artworkItems.add(new ArtworkItem(154, 23, 1986560, "Keyboard_Japanese-ver111_42.png"));
        this.artworkItems.add(new ArtworkItem(158, 28, 2002944, "Keyboard_Japanese-ver111_43.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x1EE000, "Keyboard_Japanese-ver111_44.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x232000, "Keyboard_Japanese-ver111_45.png"));
    }

    private void initKeyboard_Latin_ver111() {
        this.artworkItems = new Vector(102);
        this.artworkItems.add(new ArtworkItem(30, 42, 0, "Keyboard_Latin-ver111_0.png"));
        this.artworkItems.add(new ArtworkItem(30, 42, 8192, "Keyboard_Latin-ver111_1.png"));
        this.artworkItems.add(new ArtworkItem(85, 130, 16384, "Keyboard_Latin-ver111_2.png"));
        this.artworkItems.add(new ArtworkItem(95, 130, 65536, "Keyboard_Latin-ver111_3.png"));
        this.artworkItems.add(new ArtworkItem(105, 115, 118784, "Keyboard_Latin-ver111_4.png"));
        this.artworkItems.add(new ArtworkItem(114, 130, 172032, "Keyboard_Latin-ver111_5.png"));
        this.artworkItems.add(new ArtworkItem(85, 130, 237568, "Keyboard_Latin-ver111_6.png"));
        this.artworkItems.add(new ArtworkItem(95, 130, 286720, "Keyboard_Latin-ver111_7.png"));
        this.artworkItems.add(new ArtworkItem(27, 81, 339968, "Keyboard_Latin-ver111_8.png"));
        this.artworkItems.add(new ArtworkItem(82, 130, 352256, "Keyboard_Latin-ver111_9.png"));
        this.artworkItems.add(new ArtworkItem(1, 81, 401408, "Keyboard_Latin-ver111_10.png"));
        this.artworkItems.add(new ArtworkItem(91, 130, 405504, "Keyboard_Latin-ver111_11.png"));
        this.artworkItems.add(new ArtworkItem(94, 130, 458752, "Keyboard_Latin-ver111_12.png"));
        this.artworkItems.add(new ArtworkItem(27, 81, 512000, "Keyboard_Latin-ver111_13.png"));
        this.artworkItems.add(new ArtworkItem(82, 130, 524288, "Keyboard_Latin-ver111_14.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 573440, "Keyboard_Latin-ver111_15.png"));
        this.artworkItems.add(new ArtworkItem(83, 120, 851968, "Keyboard_Latin-ver111_16.png"));
        this.artworkItems.add(new ArtworkItem(91, 120, 897024, "Keyboard_Latin-ver111_17.png"));
        this.artworkItems.add(new ArtworkItem(88, 120, 946176, "Keyboard_Latin-ver111_18.png"));
        this.artworkItems.add(new ArtworkItem(79, 120, 991232, "Keyboard_Latin-ver111_19.png"));
        this.artworkItems.add(new ArtworkItem(114, 125, 1032192, "Keyboard_Latin-ver111_20.png"));
        this.artworkItems.add(new ArtworkItem(79, 126, 0x10B000, "Keyboard_Latin-ver111_21.png"));
        this.artworkItems.add(new ArtworkItem(78, 126, 0x115000, "Keyboard_Latin-ver111_22.png"));
        this.artworkItems.add(new ArtworkItem(220, 500, 0x11F000, "Keyboard_Latin-ver111_23.png"));
        this.artworkItems.add(new ArtworkItem(132, 750, 1626112, "Keyboard_Latin-ver111_24.png"));
        this.artworkItems.add(new ArtworkItem(132, 750, 0x1F1000, "Keyboard_Latin-ver111_25.png"));
        this.artworkItems.add(new ArtworkItem(176, 500, 0x255000, "Keyboard_Latin-ver111_26.png"));
        this.artworkItems.add(new ArtworkItem(132, 500, 2797568, "Keyboard_Latin-ver111_27.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 0x2EE000, "Keyboard_Latin-ver111_28.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 0x343000, "Keyboard_Latin-ver111_29.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 3768320, "Keyboard_Latin-ver111_30.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 4046848, "Keyboard_Latin-ver111_31.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x420000, "Keyboard_Latin-ver111_32.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x464000, "Keyboard_Latin-ver111_33.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 4882432, "Keyboard_Latin-ver111_34.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 5160960, "Keyboard_Latin-ver111_35.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x530000, "Keyboard_Latin-ver111_36.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 5718016, "Keyboard_Latin-ver111_37.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 5996544, "Keyboard_Latin-ver111_38.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 6275072, "Keyboard_Latin-ver111_39.png"));
        this.artworkItems.add(new ArtworkItem(43, 43, 0x640000, "Keyboard_Latin-ver111_40.png"));
        this.artworkItems.add(new ArtworkItem(43, 43, 6565888, "Keyboard_Latin-ver111_41.png"));
        this.artworkItems.add(new ArtworkItem(37, 43, 0x646000, "Keyboard_Latin-ver111_42.png"));
        this.artworkItems.add(new ArtworkItem(37, 43, 6586368, "Keyboard_Latin-ver111_43.png"));
        this.artworkItems.add(new ArtworkItem(1, 41, 6594560, "Keyboard_Latin-ver111_44.png"));
        this.artworkItems.add(new ArtworkItem(1, 37, 6598656, "Keyboard_Latin-ver111_45.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 6602752, "Keyboard_Latin-ver111_46.png"));
        this.artworkItems.add(new ArtworkItem(103, 120, 6950912, "Keyboard_Latin-ver111_47.png"));
        this.artworkItems.add(new ArtworkItem(115, 120, 7004160, "Keyboard_Latin-ver111_48.png"));
        this.artworkItems.add(new ArtworkItem(126, 120, 7065600, "Keyboard_Latin-ver111_49.png"));
        this.artworkItems.add(new ArtworkItem(99, 120, 0x6CC000, "Keyboard_Latin-ver111_50.png"));
        this.artworkItems.add(new ArtworkItem(110, 126, 7180288, "Keyboard_Latin-ver111_51.png"));
        this.artworkItems.add(new ArtworkItem(85, 126, 7237632, "Keyboard_Latin-ver111_52.png"));
        this.artworkItems.add(new ArtworkItem(85, 126, 7282688, "Keyboard_Latin-ver111_53.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 7327744, "Keyboard_Latin-ver111_54.png"));
        this.artworkItems.add(new ArtworkItem(52, 43, 7675904, "Keyboard_Latin-ver111_55.png"));
        this.artworkItems.add(new ArtworkItem(52, 43, 0x755000, "Keyboard_Latin-ver111_56.png"));
        this.artworkItems.add(new ArtworkItem(47, 43, 7700480, "Keyboard_Latin-ver111_57.png"));
        this.artworkItems.add(new ArtworkItem(47, 43, 7712768, "Keyboard_Latin-ver111_58.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 7725056, "Keyboard_Latin-ver111_59.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 8073216, "Keyboard_Latin-ver111_60.png"));
        this.artworkItems.add(new ArtworkItem(76, 45, 0x808000, "Keyboard_Latin-ver111_61.png"));
        this.artworkItems.add(new ArtworkItem(76, 45, 0x80C000, "Keyboard_Latin-ver111_62.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 0x810000, "Keyboard_Latin-ver111_63.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 8802304, "Keyboard_Latin-ver111_64.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 9080832, "Keyboard_Latin-ver111_65.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 9359360, "Keyboard_Latin-ver111_66.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 9637888, "Keyboard_Latin-ver111_67.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 9916416, "Keyboard_Latin-ver111_68.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x9B9000, "Keyboard_Latin-ver111_69.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 10473472, "Keyboard_Latin-ver111_70.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 10752000, "Keyboard_Latin-ver111_71.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 11030528, "Keyboard_Latin-ver111_72.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 11309056, "Keyboard_Latin-ver111_73.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0xB0D000, "Keyboard_Latin-ver111_74.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 11866112, "Keyboard_Latin-ver111_75.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 12144640, "Keyboard_Latin-ver111_76.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 12152832, "Keyboard_Latin-ver111_77.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 0xB99000, "Keyboard_Latin-ver111_78.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 0xB9B000, "Keyboard_Latin-ver111_79.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 12177408, "Keyboard_Latin-ver111_80.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 12455936, "Keyboard_Latin-ver111_81.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 12734464, "Keyboard_Latin-ver111_82.png"));
        this.artworkItems.add(new ArtworkItem(4, 36, 13012992, "Keyboard_Latin-ver111_83.png"));
        this.artworkItems.add(new ArtworkItem(4, 36, 13017088, "Keyboard_Latin-ver111_84.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 13021184, "Keyboard_Latin-ver111_85.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 13037568, "Keyboard_Latin-ver111_86.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 13053952, "Keyboard_Latin-ver111_87.png"));
        this.artworkItems.add(new ArtworkItem(43, 43, 13332480, "Keyboard_Latin-ver111_88.png"));
        this.artworkItems.add(new ArtworkItem(43, 43, 13344768, "Keyboard_Latin-ver111_89.png"));
        this.artworkItems.add(new ArtworkItem(37, 43, 13357056, "Keyboard_Latin-ver111_90.png"));
        this.artworkItems.add(new ArtworkItem(37, 43, 13365248, "Keyboard_Latin-ver111_91.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0xCC1000, "Keyboard_Latin-ver111_92.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0xD05000, "Keyboard_Latin-ver111_93.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 13930496, "Keyboard_Latin-ver111_94.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 14278656, "Keyboard_Latin-ver111_95.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 14626816, "Keyboard_Latin-ver111_96.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 14905344, "Keyboard_Latin-ver111_97.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 15183872, "Keyboard_Latin-ver111_98.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 0xED0000, "Keyboard_Latin-ver111_99.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 15880192, "Keyboard_Latin-ver111_100.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 16158720, "Keyboard_Latin-ver111_101.png"));
    }

    private void initKeyboard_Common_ver111() {
        this.artworkItems = new Vector(26);
        this.artworkItems.add(new ArtworkItem(148, 148, 0, "Keyboard_Common-ver111_0.png"));
        this.artworkItems.add(new ArtworkItem(148, 148, 90112, "Keyboard_Common-ver111_1.png"));
        this.artworkItems.add(new ArtworkItem(8, 8, 180224, "Keyboard_Common-ver111_2.png"));
        this.artworkItems.add(new ArtworkItem(16, 31, 184320, "Keyboard_Common-ver111_3.png"));
        this.artworkItems.add(new ArtworkItem(16, 31, 188416, "Keyboard_Common-ver111_4.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 192512, "Keyboard_Common-ver111_5.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 196608, "Keyboard_Common-ver111_6.png"));
        this.artworkItems.add(new ArtworkItem(98, 42, 200704, "Keyboard_Common-ver111_7.png"));
        this.artworkItems.add(new ArtworkItem(98, 42, 221184, "Keyboard_Common-ver111_8.png"));
        this.artworkItems.add(new ArtworkItem(98, 42, 241664, "Keyboard_Common-ver111_9.png"));
        this.artworkItems.add(new ArtworkItem(289, 42, 262144, "Keyboard_Common-ver111_10.png"));
        this.artworkItems.add(new ArtworkItem(289, 42, 315392, "Keyboard_Common-ver111_11.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 368640, "Keyboard_Common-ver111_12.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 385024, "Keyboard_Common-ver111_13.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 401408, "Keyboard_Common-ver111_14.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 417792, "Keyboard_Common-ver111_15.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 434176, "Keyboard_Common-ver111_16.png"));
        this.artworkItems.add(new ArtworkItem(160, 44, 450560, "Keyboard_Common-ver111_17.png"));
        this.artworkItems.add(new ArtworkItem(160, 44, 479232, "Keyboard_Common-ver111_18.png"));
        this.artworkItems.add(new ArtworkItem(160, 44, 507904, "Keyboard_Common-ver111_19.png"));
        this.artworkItems.add(new ArtworkItem(160, 44, 536576, "Keyboard_Common-ver111_20.png"));
        this.artworkItems.add(new ArtworkItem(127, 127, 565248, "Keyboard_Common-ver111_21.png"));
        this.artworkItems.add(new ArtworkItem(127, 127, 630784, "Keyboard_Common-ver111_22.png"));
        this.artworkItems.add(new ArtworkItem(127, 127, 696320, "Keyboard_Common-ver111_23.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 761856, "Keyboard_Common-ver111_24.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 765952, "Keyboard_Common-ver111_25.png"));
    }

    private void initKeyboard_Common_ver114() {
        this.artworkItems = new Vector(34);
        this.artworkItems.add(new ArtworkItem(148, 148, 0, "Keyboard_Common-ver114_00.png"));
        this.artworkItems.add(new ArtworkItem(148, 148, 90112, "Keyboard_Common-ver114_01.png"));
        this.artworkItems.add(new ArtworkItem(8, 8, 180224, "Keyboard_Common-ver114_02.png"));
        this.artworkItems.add(new ArtworkItem(16, 31, 184320, "Keyboard_Common-ver114_03.png"));
        this.artworkItems.add(new ArtworkItem(16, 31, 188416, "Keyboard_Common-ver114_04.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 192512, "Keyboard_Common-ver114_05.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 196608, "Keyboard_Common-ver114_06.png"));
        this.artworkItems.add(new ArtworkItem(98, 42, 200704, "Keyboard_Common-ver114_07.png"));
        this.artworkItems.add(new ArtworkItem(96, 34, 221184, "Keyboard_Common-ver114_08.png"));
        this.artworkItems.add(new ArtworkItem(96, 34, 237568, "Keyboard_Common-ver114_09.png"));
        this.artworkItems.add(new ArtworkItem(96, 34, 253952, "Keyboard_Common-ver114_10.png"));
        this.artworkItems.add(new ArtworkItem(98, 42, 270336, "Keyboard_Common-ver114_11.png"));
        this.artworkItems.add(new ArtworkItem(98, 42, 290816, "Keyboard_Common-ver114_12.png"));
        this.artworkItems.add(new ArtworkItem(289, 42, 311296, "Keyboard_Common-ver114_13.png"));
        this.artworkItems.add(new ArtworkItem(289, 42, 364544, "Keyboard_Common-ver114_14.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 417792, "Keyboard_Common-ver114_15.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 434176, "Keyboard_Common-ver114_16.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 450560, "Keyboard_Common-ver114_17.png"));
        this.artworkItems.add(new ArtworkItem(80, 28, 466944, "Keyboard_Common-ver114_18.png"));
        this.artworkItems.add(new ArtworkItem(80, 28, 479232, "Keyboard_Common-ver114_19.png"));
        this.artworkItems.add(new ArtworkItem(80, 28, 491520, "Keyboard_Common-ver114_20.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 503808, "Keyboard_Common-ver114_21.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 520192, "Keyboard_Common-ver114_22.png"));
        this.artworkItems.add(new ArtworkItem(160, 44, 536576, "Keyboard_Common-ver114_23.png"));
        this.artworkItems.add(new ArtworkItem(160, 44, 565248, "Keyboard_Common-ver114_24.png"));
        this.artworkItems.add(new ArtworkItem(53, 44, 593920, "Keyboard_Common-ver114_25.png"));
        this.artworkItems.add(new ArtworkItem(53, 44, 606208, "Keyboard_Common-ver114_26.png"));
        this.artworkItems.add(new ArtworkItem(160, 44, 618496, "Keyboard_Common-ver114_27.png"));
        this.artworkItems.add(new ArtworkItem(160, 44, 647168, "Keyboard_Common-ver114_28.png"));
        this.artworkItems.add(new ArtworkItem(127, 127, 675840, "Keyboard_Common-ver114_29.png"));
        this.artworkItems.add(new ArtworkItem(127, 127, 741376, "Keyboard_Common-ver114_30.png"));
        this.artworkItems.add(new ArtworkItem(127, 127, 806912, "Keyboard_Common-ver114_31.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 872448, "Keyboard_Common-ver114_32.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 876544, "Keyboard_Common-ver114_33.png"));
    }

    private void initKeyboard_Latin_ver114() {
        this.artworkItems = new Vector(105);
        this.artworkItems.add(new ArtworkItem(30, 42, 0, "Keyboard_Latin-ver114_000.png"));
        this.artworkItems.add(new ArtworkItem(30, 42, 8192, "Keyboard_Latin-ver114_001.png"));
        this.artworkItems.add(new ArtworkItem(85, 130, 16384, "Keyboard_Latin-ver114_002.png"));
        this.artworkItems.add(new ArtworkItem(95, 130, 65536, "Keyboard_Latin-ver114_003.png"));
        this.artworkItems.add(new ArtworkItem(105, 115, 118784, "Keyboard_Latin-ver114_004.png"));
        this.artworkItems.add(new ArtworkItem(114, 130, 172032, "Keyboard_Latin-ver114_005.png"));
        this.artworkItems.add(new ArtworkItem(85, 130, 237568, "Keyboard_Latin-ver114_006.png"));
        this.artworkItems.add(new ArtworkItem(95, 130, 286720, "Keyboard_Latin-ver114_007.png"));
        this.artworkItems.add(new ArtworkItem(142, 133, 339968, "Keyboard_Latin-ver114_008.png"));
        this.artworkItems.add(new ArtworkItem(27, 81, 417792, "Keyboard_Latin-ver114_009.png"));
        this.artworkItems.add(new ArtworkItem(82, 130, 430080, "Keyboard_Latin-ver114_010.png"));
        this.artworkItems.add(new ArtworkItem(1, 81, 479232, "Keyboard_Latin-ver114_011.png"));
        this.artworkItems.add(new ArtworkItem(91, 130, 483328, "Keyboard_Latin-ver114_012.png"));
        this.artworkItems.add(new ArtworkItem(94, 130, 536576, "Keyboard_Latin-ver114_013.png"));
        this.artworkItems.add(new ArtworkItem(27, 81, 589824, "Keyboard_Latin-ver114_014.png"));
        this.artworkItems.add(new ArtworkItem(82, 130, 602112, "Keyboard_Latin-ver114_015.png"));
        this.artworkItems.add(new ArtworkItem(104, 137, 651264, "Keyboard_Latin-ver114_016.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 708608, "Keyboard_Latin-ver114_017.png"));
        this.artworkItems.add(new ArtworkItem(83, 120, 987136, "Keyboard_Latin-ver114_018.png"));
        this.artworkItems.add(new ArtworkItem(91, 120, 1032192, "Keyboard_Latin-ver114_019.png"));
        this.artworkItems.add(new ArtworkItem(88, 120, 0x108000, "Keyboard_Latin-ver114_020.png"));
        this.artworkItems.add(new ArtworkItem(79, 120, 0x113000, "Keyboard_Latin-ver114_021.png"));
        this.artworkItems.add(new ArtworkItem(114, 125, 0x11D000, "Keyboard_Latin-ver114_022.png"));
        this.artworkItems.add(new ArtworkItem(78, 126, 1228800, "Keyboard_Latin-ver114_023.png"));
        this.artworkItems.add(new ArtworkItem(78, 126, 1269760, "Keyboard_Latin-ver114_024.png"));
        this.artworkItems.add(new ArtworkItem(220, 500, 0x140000, "Keyboard_Latin-ver114_025.png"));
        this.artworkItems.add(new ArtworkItem(132, 750, 1761280, "Keyboard_Latin-ver114_026.png"));
        this.artworkItems.add(new ArtworkItem(132, 750, 0x212000, "Keyboard_Latin-ver114_027.png"));
        this.artworkItems.add(new ArtworkItem(176, 500, 2580480, "Keyboard_Latin-ver114_028.png"));
        this.artworkItems.add(new ArtworkItem(132, 500, 0x2CC000, "Keyboard_Latin-ver114_029.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 0x30F000, "Keyboard_Latin-ver114_030.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 3555328, "Keyboard_Latin-ver114_031.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 3903488, "Keyboard_Latin-ver114_032.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 4182016, "Keyboard_Latin-ver114_033.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x441000, "Keyboard_Latin-ver114_034.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 4739072, "Keyboard_Latin-ver114_035.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 5017600, "Keyboard_Latin-ver114_036.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x50D000, "Keyboard_Latin-ver114_037.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x551000, "Keyboard_Latin-ver114_038.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x595000, "Keyboard_Latin-ver114_039.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 6131712, "Keyboard_Latin-ver114_040.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 6410240, "Keyboard_Latin-ver114_041.png"));
        this.artworkItems.add(new ArtworkItem(43, 43, 0x661000, "Keyboard_Latin-ver114_042.png"));
        this.artworkItems.add(new ArtworkItem(43, 43, 0x664000, "Keyboard_Latin-ver114_043.png"));
        this.artworkItems.add(new ArtworkItem(37, 43, 0x667000, "Keyboard_Latin-ver114_044.png"));
        this.artworkItems.add(new ArtworkItem(37, 43, 0x669000, "Keyboard_Latin-ver114_045.png"));
        this.artworkItems.add(new ArtworkItem(1, 41, 0x66B000, "Keyboard_Latin-ver114_046.png"));
        this.artworkItems.add(new ArtworkItem(1, 37, 0x66C000, "Keyboard_Latin-ver114_047.png"));
        this.artworkItems.add(new ArtworkItem(1, 19, 0x66D000, "Keyboard_Latin-ver114_048.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 0x66E000, "Keyboard_Latin-ver114_049.png"));
        this.artworkItems.add(new ArtworkItem(103, 120, 7090176, "Keyboard_Latin-ver114_050.png"));
        this.artworkItems.add(new ArtworkItem(115, 120, 0x6D0000, "Keyboard_Latin-ver114_051.png"));
        this.artworkItems.add(new ArtworkItem(126, 120, 7204864, "Keyboard_Latin-ver114_052.png"));
        this.artworkItems.add(new ArtworkItem(99, 120, 0x6EE000, "Keyboard_Latin-ver114_053.png"));
        this.artworkItems.add(new ArtworkItem(110, 126, 7319552, "Keyboard_Latin-ver114_054.png"));
        this.artworkItems.add(new ArtworkItem(85, 126, 0x709000, "Keyboard_Latin-ver114_055.png"));
        this.artworkItems.add(new ArtworkItem(85, 126, 7421952, "Keyboard_Latin-ver114_056.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 7467008, "Keyboard_Latin-ver114_057.png"));
        this.artworkItems.add(new ArtworkItem(52, 43, 0x774000, "Keyboard_Latin-ver114_058.png"));
        this.artworkItems.add(new ArtworkItem(52, 43, 0x777000, "Keyboard_Latin-ver114_059.png"));
        this.artworkItems.add(new ArtworkItem(47, 43, 0x77A000, "Keyboard_Latin-ver114_060.png"));
        this.artworkItems.add(new ArtworkItem(47, 43, 0x77D000, "Keyboard_Latin-ver114_061.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 0x780000, "Keyboard_Latin-ver114_062.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 8212480, "Keyboard_Latin-ver114_063.png"));
        this.artworkItems.add(new ArtworkItem(76, 45, 8560640, "Keyboard_Latin-ver114_064.png"));
        this.artworkItems.add(new ArtworkItem(76, 45, 8577024, "Keyboard_Latin-ver114_065.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 8593408, "Keyboard_Latin-ver114_066.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x887000, "Keyboard_Latin-ver114_067.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 9220096, "Keyboard_Latin-ver114_068.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x90F000, "Keyboard_Latin-ver114_069.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 9777152, "Keyboard_Latin-ver114_070.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x997000, "Keyboard_Latin-ver114_071.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 10334208, "Keyboard_Latin-ver114_072.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 10612736, "Keyboard_Latin-ver114_073.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 10891264, "Keyboard_Latin-ver114_074.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0xAA7000, "Keyboard_Latin-ver114_075.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 11448320, "Keyboard_Latin-ver114_076.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 11726848, "Keyboard_Latin-ver114_077.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 12005376, "Keyboard_Latin-ver114_078.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 0xBB7000, "Keyboard_Latin-ver114_079.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 0xBB9000, "Keyboard_Latin-ver114_080.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 0xBBB000, "Keyboard_Latin-ver114_081.png"));
        this.artworkItems.add(new ArtworkItem(40, 41, 0xBBD000, "Keyboard_Latin-ver114_082.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0xBBF000, "Keyboard_Latin-ver114_083.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0xC03000, "Keyboard_Latin-ver114_084.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 12873728, "Keyboard_Latin-ver114_085.png"));
        this.artworkItems.add(new ArtworkItem(4, 36, 13152256, "Keyboard_Latin-ver114_086.png"));
        this.artworkItems.add(new ArtworkItem(4, 36, 0xC8C000, "Keyboard_Latin-ver114_087.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 13160448, "Keyboard_Latin-ver114_088.png"));
        this.artworkItems.add(new ArtworkItem(80, 44, 13176832, "Keyboard_Latin-ver114_089.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 13193216, "Keyboard_Latin-ver114_090.png"));
        this.artworkItems.add(new ArtworkItem(43, 43, 13471744, "Keyboard_Latin-ver114_091.png"));
        this.artworkItems.add(new ArtworkItem(43, 43, 0xCDC000, "Keyboard_Latin-ver114_092.png"));
        this.artworkItems.add(new ArtworkItem(37, 43, 13496320, "Keyboard_Latin-ver114_093.png"));
        this.artworkItems.add(new ArtworkItem(37, 43, 13504512, "Keyboard_Latin-ver114_094.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 13512704, "Keyboard_Latin-ver114_095.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 13791232, "Keyboard_Latin-ver114_096.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 14069760, "Keyboard_Latin-ver114_097.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 0xDC0000, "Keyboard_Latin-ver114_098.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 14766080, "Keyboard_Latin-ver114_099.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 15044608, "Keyboard_Latin-ver114_100.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 15323136, "Keyboard_Latin-ver114_101.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 15671296, "Keyboard_Latin-ver114_102.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 16019456, "Keyboard_Latin-ver114_103.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 16297984, "Keyboard_Latin-ver114_104.png"));
    }

    private void initOther_ver114() {
        this.artworkItems = new Vector(360);
        this.artworkItems.add(new ArtworkItem(16, 20, 0, "Other-ver114_0.png"));
        this.artworkItems.add(new ArtworkItem(16, 20, 4096, "Other-ver114_1.png"));
        this.artworkItems.add(new ArtworkItem(320, 480, 8192, "Other-ver114_2.png"));
        this.artworkItems.add(new ArtworkItem(320, 480, 622592, "Other-ver114_3.png"));
        this.artworkItems.add(new ArtworkItem(1, 222, 1236992, "Other-ver114_4.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 0x130000, "Other-ver114_5.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 0x131000, "Other-ver114_6.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 1253376, "Other-ver114_7.png"));
        this.artworkItems.add(new ArtworkItem(6, 12, 0x133000, "Other-ver114_8.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 1261568, "Other-ver114_9.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 1265664, "Other-ver114_10.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 1269760, "Other-ver114_11.png"));
        this.artworkItems.add(new ArtworkItem(9, 18, 1273856, "Other-ver114_12.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1277952, "Other-ver114_13.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1282048, "Other-ver114_14.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1286144, "Other-ver114_15.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1290240, "Other-ver114_16.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1294336, "Other-ver114_17.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1302528, "Other-ver114_18.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1306624, "Other-ver114_19.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 0x140000, "Other-ver114_20.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x141000, "Other-ver114_21.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1318912, "Other-ver114_22.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1323008, "Other-ver114_23.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1331200, "Other-ver114_24.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1335296, "Other-ver114_25.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1339392, "Other-ver114_26.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1343488, "Other-ver114_27.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1347584, "Other-ver114_28.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1351680, "Other-ver114_29.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1351680, "Other-ver114_29.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1359872, "Other-ver114_30.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1363968, "Other-ver114_31.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1368064, "Other-ver114_32.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1372160, "Other-ver114_33.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x150000, "Other-ver114_34.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x151000, "Other-ver114_35.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1384448, "Other-ver114_36.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1388544, "Other-ver114_37.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1392640, "Other-ver114_38.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x155000, "Other-ver114_39.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1400832, "Other-ver114_40.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1404928, "Other-ver114_41.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1409024, "Other-ver114_42.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1413120, "Other-ver114_43.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1417216, "Other-ver114_44.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1421312, "Other-ver114_45.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1425408, "Other-ver114_46.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1429504, "Other-ver114_47.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1437696, "Other-ver114_48.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x160000, "Other-ver114_49.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 0x161000, "Other-ver114_50.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1449984, "Other-ver114_51.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1454080, "Other-ver114_52.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1458176, "Other-ver114_53.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x166000, "Other-ver114_54.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1470464, "Other-ver114_55.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1474560, "Other-ver114_56.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1478656, "Other-ver114_57.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1482752, "Other-ver114_58.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1486848, "Other-ver114_59.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1495040, "Other-ver114_60.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1499136, "Other-ver114_61.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1503232, "Other-ver114_62.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x170000, "Other-ver114_63.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 0x171000, "Other-ver114_64.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1515520, "Other-ver114_65.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1523712, "Other-ver114_66.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1527808, "Other-ver114_67.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1531904, "Other-ver114_68.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x177000, "Other-ver114_69.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1540096, "Other-ver114_70.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1544192, "Other-ver114_71.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1552384, "Other-ver114_72.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1556480, "Other-ver114_73.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1560576, "Other-ver114_74.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1564672, "Other-ver114_75.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1568768, "Other-ver114_76.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 0x180000, "Other-ver114_77.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1581056, "Other-ver114_78.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1585152, "Other-ver114_79.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1589248, "Other-ver114_80.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1593344, "Other-ver114_81.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1597440, "Other-ver114_82.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1601536, "Other-ver114_83.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1609728, "Other-ver114_84.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1613824, "Other-ver114_85.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1617920, "Other-ver114_86.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1622016, "Other-ver114_87.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1626112, "Other-ver114_88.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1630208, "Other-ver114_89.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x190000, "Other-ver114_90.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 0x191000, "Other-ver114_91.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1646592, "Other-ver114_92.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1650688, "Other-ver114_93.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1654784, "Other-ver114_94.png"));
        this.artworkItems.add(new ArtworkItem(37, 37, 1658880, "Other-ver114_95.png"));
        this.artworkItems.add(new ArtworkItem(14, 15, 1667072, "Other-ver114_96.png"));
        this.artworkItems.add(new ArtworkItem(1, 22, 1671168, "Other-ver114_97.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 0x199000, "Other-ver114_98.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 1683456, "Other-ver114_99.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 1691648, "Other-ver114_100.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 1699840, "Other-ver114_101.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 0x1A1000, "Other-ver114_102.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 1716224, "Other-ver114_103.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 1724416, "Other-ver114_104.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1732608, "Other-ver114_105.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 1736704, "Other-ver114_106.png"));
        this.artworkItems.add(new ArtworkItem(27, 46, 0x1AA000, "Other-ver114_107.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 1753088, "Other-ver114_108.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 1761280, "Other-ver114_109.png"));
        this.artworkItems.add(new ArtworkItem(25, 46, 0x1B0000, "Other-ver114_110.png"));
        this.artworkItems.add(new ArtworkItem(280, 2, 1777664, "Other-ver114_111.png"));
        this.artworkItems.add(new ArtworkItem(3, 31, 1781760, "Other-ver114_112.png"));
        this.artworkItems.add(new ArtworkItem(27, 28, 1785856, "Other-ver114_113.png"));
        this.artworkItems.add(new ArtworkItem(27, 28, 1789952, "Other-ver114_114.png"));
        this.artworkItems.add(new ArtworkItem(22, 23, 1794048, "Other-ver114_115.png"));
        this.artworkItems.add(new ArtworkItem(27, 28, 1798144, "Other-ver114_116.png"));
        this.artworkItems.add(new ArtworkItem(27, 28, 1802240, "Other-ver114_117.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1806336, "Other-ver114_118.png"));
        this.artworkItems.add(new ArtworkItem(1, 49, 1810432, "Other-ver114_119.png"));
        this.artworkItems.add(new ArtworkItem(11, 24, 0x1BB000, "Other-ver114_120.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 1818624, "Other-ver114_121.png"));
        this.artworkItems.add(new ArtworkItem(1, 32, 1822720, "Other-ver114_122.png"));
        this.artworkItems.add(new ArtworkItem(20, 20, 1826816, "Other-ver114_123.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1830912, "Other-ver114_124.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 0x1C1000, "Other-ver114_125.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1847296, "Other-ver114_126.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1855488, "Other-ver114_127.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1863680, "Other-ver114_128.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1871872, "Other-ver114_129.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1880064, "Other-ver114_130.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1888256, "Other-ver114_131.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1896448, "Other-ver114_132.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 0x1D1000, "Other-ver114_133.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1912832, "Other-ver114_134.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1921024, "Other-ver114_135.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1929216, "Other-ver114_136.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1937408, "Other-ver114_137.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1945600, "Other-ver114_138.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 0x1DD000, "Other-ver114_139.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1961984, "Other-ver114_140.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 0x1E1000, "Other-ver114_141.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1978368, "Other-ver114_142.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1986560, "Other-ver114_143.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 1994752, "Other-ver114_144.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2002944, "Other-ver114_145.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2011136, "Other-ver114_146.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2019328, "Other-ver114_147.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2027520, "Other-ver114_148.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 0x1F1000, "Other-ver114_149.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2043904, "Other-ver114_150.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2052096, "Other-ver114_151.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2060288, "Other-ver114_152.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2068480, "Other-ver114_153.png"));
        this.artworkItems.add(new ArtworkItem(31, 36, 2076672, "Other-ver114_154.png"));
        this.artworkItems.add(new ArtworkItem(18, 19, 2084864, "Other-ver114_155.png"));
        this.artworkItems.add(new ArtworkItem(11, 24, 2088960, "Other-ver114_156.png"));
        this.artworkItems.add(new ArtworkItem(11, 24, 0x1FF000, "Other-ver114_157.png"));
        this.artworkItems.add(new ArtworkItem(16, 17, 0x200000, "Other-ver114_158.png"));
        this.artworkItems.add(new ArtworkItem(100, 100, 0x201000, "Other-ver114_159.png"));
        this.artworkItems.add(new ArtworkItem(7, 7, 0x20C000, "Other-ver114_160.png"));
        this.artworkItems.add(new ArtworkItem(18, 19, 0x20D000, "Other-ver114_161.png"));
        this.artworkItems.add(new ArtworkItem(18, 19, 0x20E000, "Other-ver114_162.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 0x20F000, "Other-ver114_163.png"));
        this.artworkItems.add(new ArtworkItem(1, 57, 0x210000, "Other-ver114_164.png"));
        this.artworkItems.add(new ArtworkItem(41, 70, 0x211000, "Other-ver114_165.png"));
        this.artworkItems.add(new ArtworkItem(17, 57, 2183168, "Other-ver114_166.png"));
        this.artworkItems.add(new ArtworkItem(17, 57, 2191360, "Other-ver114_167.png"));
        this.artworkItems.add(new ArtworkItem(41, 70, 2199552, "Other-ver114_168.png"));
        this.artworkItems.add(new ArtworkItem(3, 19, 2215936, "Other-ver114_169.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 2220032, "Other-ver114_170.png"));
        this.artworkItems.add(new ArtworkItem(1, 96, 2224128, "Other-ver114_171.png"));
        this.artworkItems.add(new ArtworkItem(13, 16, 0x220000, "Other-ver114_172.png"));
        this.artworkItems.add(new ArtworkItem(23, 19, 0x221000, "Other-ver114_173.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 0x222000, "Other-ver114_174.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x223000, "Other-ver114_175.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 0x224000, "Other-ver114_176.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 0x225000, "Other-ver114_177.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x226000, "Other-ver114_178.png"));
        this.artworkItems.add(new ArtworkItem(1, 74, 0x227000, "Other-ver114_179.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 0x228000, "Other-ver114_180.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 0x229000, "Other-ver114_181.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x22A000, "Other-ver114_182.png"));
        this.artworkItems.add(new ArtworkItem(1, 74, 0x22B000, "Other-ver114_183.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 0x22C000, "Other-ver114_184.png"));
        this.artworkItems.add(new ArtworkItem(21, 30, 0x22D000, "Other-ver114_185.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 0x22E000, "Other-ver114_186.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x22F000, "Other-ver114_187.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x230000, "Other-ver114_188.png"));
        this.artworkItems.add(new ArtworkItem(1, 74, 2297856, "Other-ver114_189.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x232000, "Other-ver114_190.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 0x233000, "Other-ver114_191.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 2310144, "Other-ver114_192.png"));
        this.artworkItems.add(new ArtworkItem(11, 30, 2314240, "Other-ver114_193.png"));
        this.artworkItems.add(new ArtworkItem(6, 6, 2318336, "Other-ver114_194.png"));
        this.artworkItems.add(new ArtworkItem(6, 6, 2322432, "Other-ver114_195.png"));
        this.artworkItems.add(new ArtworkItem(62, 52, 2326528, "Other-ver114_196.png"));
        this.artworkItems.add(new ArtworkItem(11, 53, 2342912, "Other-ver114_197.png"));
        this.artworkItems.add(new ArtworkItem(15, 39, 2347008, "Other-ver114_198.png"));
        this.artworkItems.add(new ArtworkItem(18, 18, 2351104, "Other-ver114_199.png"));
        this.artworkItems.add(new ArtworkItem(1, 180, 2355200, "Other-ver114_200.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 2363392, "Other-ver114_201.png"));
        this.artworkItems.add(new ArtworkItem(15, 180, 2371584, "Other-ver114_202.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 2383872, "Other-ver114_203.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 2400256, "Other-ver114_204.png"));
        this.artworkItems.add(new ArtworkItem(1, 180, 2416640, "Other-ver114_205.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 0x250000, "Other-ver114_206.png"));
        this.artworkItems.add(new ArtworkItem(15, 180, 0x252000, "Other-ver114_207.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 0x255000, "Other-ver114_208.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 2461696, "Other-ver114_209.png"));
        this.artworkItems.add(new ArtworkItem(9, 44, 2478080, "Other-ver114_210.png"));
        this.artworkItems.add(new ArtworkItem(1, 48, 2482176, "Other-ver114_211.png"));
        this.artworkItems.add(new ArtworkItem(1, 62, 2486272, "Other-ver114_212.png"));
        this.artworkItems.add(new ArtworkItem(1, 180, 0x260000, "Other-ver114_213.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 0x262000, "Other-ver114_214.png"));
        this.artworkItems.add(new ArtworkItem(9, 180, 2506752, "Other-ver114_215.png"));
        this.artworkItems.add(new ArtworkItem(9, 216, 2519040, "Other-ver114_216.png"));
        this.artworkItems.add(new ArtworkItem(7, 1, 2535424, "Other-ver114_217.png"));
        this.artworkItems.add(new ArtworkItem(19, 46, 2539520, "Other-ver114_218.png"));
        this.artworkItems.add(new ArtworkItem(19, 46, 2547712, "Other-ver114_219.png"));
        this.artworkItems.add(new ArtworkItem(11, 14, 0x270000, "Other-ver114_220.png"));
        this.artworkItems.add(new ArtworkItem(284, 62, 2560000, "Other-ver114_221.png"));
        this.artworkItems.add(new ArtworkItem(11, 43, 2633728, "Other-ver114_222.png"));
        this.artworkItems.add(new ArtworkItem(11, 43, 2637824, "Other-ver114_223.png"));
        this.artworkItems.add(new ArtworkItem(11, 43, 2641920, "Other-ver114_224.png"));
        this.artworkItems.add(new ArtworkItem(14, 14, 2646016, "Other-ver114_225.png"));
        this.artworkItems.add(new ArtworkItem(13, 44, 2650112, "Other-ver114_226.png"));
        this.artworkItems.add(new ArtworkItem(13, 44, 0x288000, "Other-ver114_227.png"));
        this.artworkItems.add(new ArtworkItem(14, 14, 2658304, "Other-ver114_228.png"));
        this.artworkItems.add(new ArtworkItem(15, 11, 2662400, "Other-ver114_229.png"));
        this.artworkItems.add(new ArtworkItem(14, 14, 2666496, "Other-ver114_230.png"));
        this.artworkItems.add(new ArtworkItem(29, 29, 2670592, "Other-ver114_231.png"));
        this.artworkItems.add(new ArtworkItem(13, 3, 2674688, "Other-ver114_232.png"));
        this.artworkItems.add(new ArtworkItem(29, 29, 2678784, "Other-ver114_233.png"));
        this.artworkItems.add(new ArtworkItem(17, 33, 2682880, "Other-ver114_234.png"));
        this.artworkItems.add(new ArtworkItem(17, 33, 0x290000, "Other-ver114_235.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 2691072, "Other-ver114_236.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 168448, "Other-ver114_237.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 2699264, "Other-ver114_238.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 2703360, "Other-ver114_239.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 2707456, "Other-ver114_240.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 2711552, "Other-ver114_241.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 2715648, "Other-ver114_242.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 2719744, "Other-ver114_243.png"));
        this.artworkItems.add(new ArtworkItem(8, 31, 0x299000, "Other-ver114_244.png"));
        this.artworkItems.add(new ArtworkItem(5, 5, 2727936, "Other-ver114_245.png"));
        this.artworkItems.add(new ArtworkItem(7, 7, 2732032, "Other-ver114_246.png"));
        this.artworkItems.add(new ArtworkItem(5, 5, 2736128, "Other-ver114_247.png"));
        this.artworkItems.add(new ArtworkItem(54, 54, 2740224, "Other-ver114_248.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 2789376, "Other-ver114_249.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 2756608, "Other-ver114_250.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 0x2A2000, "Other-ver114_251.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 2764800, "Other-ver114_252.png"));
        this.artworkItems.add(new ArtworkItem(1, 8, 2768896, "Other-ver114_253.png"));
        this.artworkItems.add(new ArtworkItem(4, 8, 2772992, "Other-ver114_254.png"));
        this.artworkItems.add(new ArtworkItem(4, 8, 2777088, "Other-ver114_255.png"));
        this.artworkItems.add(new ArtworkItem(17, 18, 2781184, "Other-ver114_256.png"));
        this.artworkItems.add(new ArtworkItem(22, 24, 2785280, "Other-ver114_257.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 2789376, "Other-ver114_258.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 0x2AA000, "Other-ver114_259.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 2797568, "Other-ver114_260.png"));
        this.artworkItems.add(new ArtworkItem(15, 15, 2801664, "Other-ver114_261.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 2805760, "Other-ver114_262.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 2809856, "Other-ver114_263.png"));
        this.artworkItems.add(new ArtworkItem(17, 32, 2813952, "Other-ver114_264.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 0x2A0000, "Other-ver114_265.png"));
        this.artworkItems.add(new ArtworkItem(1, 31, 2822144, "Other-ver114_266.png"));
        this.artworkItems.add(new ArtworkItem(1, 32, 0x2B2000, "Other-ver114_267.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 2830336, "Other-ver114_268.png"));
        this.artworkItems.add(new ArtworkItem(17, 31, 2834432, "Other-ver114_269.png"));
        this.artworkItems.add(new ArtworkItem(17, 32, 2838528, "Other-ver114_270.png"));
        this.artworkItems.add(new ArtworkItem(1, 23, 2842624, "Other-ver114_271.png"));
        this.artworkItems.add(new ArtworkItem(1, 23, 2846720, "Other-ver114_272.png"));
        this.artworkItems.add(new ArtworkItem(8, 10, 2850816, "Other-ver114_273.png"));
        this.artworkItems.add(new ArtworkItem(13, 30, 2854912, "Other-ver114_274.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 2859008, "Other-ver114_275.png"));
        this.artworkItems.add(new ArtworkItem(6, 30, 0x2BB000, "Other-ver114_276.png"));
        this.artworkItems.add(new ArtworkItem(6, 30, 2867200, "Other-ver114_277.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 2871296, "Other-ver114_278.png"));
        this.artworkItems.add(new ArtworkItem(1, 30, 2875392, "Other-ver114_279.png"));
        this.artworkItems.add(new ArtworkItem(21, 44, 2879488, "Other-ver114_280.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 2887680, "Other-ver114_281.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 0x2C2000, "Other-ver114_282.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 2895872, "Other-ver114_283.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 2899968, "Other-ver114_284.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 2904064, "Other-ver114_285.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 2908160, "Other-ver114_286.png"));
        this.artworkItems.add(new ArtworkItem(21, 44, 2912256, "Other-ver114_287.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 2920448, "Other-ver114_288.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 2924544, "Other-ver114_289.png"));
        this.artworkItems.add(new ArtworkItem(10, 44, 2928640, "Other-ver114_290.png"));
        this.artworkItems.add(new ArtworkItem(1, 44, 0x2CC000, "Other-ver114_291.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 2936832, "Other-ver114_292.png"));
        this.artworkItems.add(new ArtworkItem(6, 44, 2940928, "Other-ver114_293.png"));
        this.artworkItems.add(new ArtworkItem(46, 46, 2945024, "Other-ver114_294.png"));
        this.artworkItems.add(new ArtworkItem(9, 46, 0x2D2000, "Other-ver114_295.png"));
        this.artworkItems.add(new ArtworkItem(9, 46, 2961408, "Other-ver114_296.png"));
        this.artworkItems.add(new ArtworkItem(46, 46, 2965504, "Other-ver114_297.png"));
        this.artworkItems.add(new ArtworkItem(46, 46, 2977792, "Other-ver114_298.png"));
        this.artworkItems.add(new ArtworkItem(9, 46, 2990080, "Other-ver114_299.png"));
        this.artworkItems.add(new ArtworkItem(9, 46, 2994176, "Other-ver114_300.png"));
        this.artworkItems.add(new ArtworkItem(9, 46, 2998272, "Other-ver114_301.png"));
        this.artworkItems.add(new ArtworkItem(9, 46, 0x2DD000, "Other-ver114_302.png"));
        this.artworkItems.add(new ArtworkItem(1, 46, 3006464, "Other-ver114_303.png"));
        this.artworkItems.add(new ArtworkItem(1, 46, 3010560, "Other-ver114_304.png"));
        this.artworkItems.add(new ArtworkItem(1, 46, 0x2E0000, "Other-ver114_305.png"));
        this.artworkItems.add(new ArtworkItem(1, 46, 3018752, "Other-ver114_306.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 0x2E2000, "Other-ver114_307.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 3026944, "Other-ver114_308.png"));
        this.artworkItems.add(new ArtworkItem(23, 23, 3031040, "Other-ver114_309.png"));
        this.artworkItems.add(new ArtworkItem(23, 23, 3035136, "Other-ver114_310.png"));
        this.artworkItems.add(new ArtworkItem(5, 9, 3039232, "Other-ver114_311.png"));
        this.artworkItems.add(new ArtworkItem(1, 9, 3043328, "Other-ver114_312.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 3047424, "Other-ver114_313.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 3051520, "Other-ver114_314.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 3055616, "Other-ver114_315.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 3059712, "Other-ver114_316.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 3063808, "Other-ver114_317.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 3067904, "Other-ver114_318.png"));
        this.artworkItems.add(new ArtworkItem(14, 16, 0x2EE000, "Other-ver114_319.png"));
        this.artworkItems.add(new ArtworkItem(2, 16, 3076096, "Other-ver114_320.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 0x2F0000, "Other-ver114_321.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 3084288, "Other-ver114_322.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 0x2F2000, "Other-ver114_323.png"));
        this.artworkItems.add(new ArtworkItem(8, 27, 3092480, "Other-ver114_324.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 3096576, "Other-ver114_325.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 3100672, "Other-ver114_326.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 3104768, "Other-ver114_327.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 3108864, "Other-ver114_328.png"));
        this.artworkItems.add(new ArtworkItem(5, 27, 3112960, "Other-ver114_329.png"));
        this.artworkItems.add(new ArtworkItem(1, 27, 3117056, "Other-ver114_330.png"));
        this.artworkItems.add(new ArtworkItem(3, 19, 3121152, "Other-ver114_331.png"));
        this.artworkItems.add(new ArtworkItem(3, 19, 3125248, "Other-ver114_332.png"));
        this.artworkItems.add(new ArtworkItem(19, 17, 3129344, "Other-ver114_333.png"));
        this.artworkItems.add(new ArtworkItem(10, 13, 3133440, "Other-ver114_334.png"));
        this.artworkItems.add(new ArtworkItem(29, 31, 3137536, "Other-ver114_335.png"));
        this.artworkItems.add(new ArtworkItem(29, 31, 0x2FF000, "Other-ver114_336.png"));
        this.artworkItems.add(new ArtworkItem(10, 13, 0x300000, "Other-ver114_337.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 0x301000, "Other-ver114_338.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 0x302000, "Other-ver114_339.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 0x303000, "Other-ver114_340.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 0x304000, "Other-ver114_341.png"));
        this.artworkItems.add(new ArtworkItem(1, 43, 0x305000, "Other-ver114_342.png"));
        this.artworkItems.add(new ArtworkItem(19, 19, 0x306000, "Other-ver114_343.png"));
        this.artworkItems.add(new ArtworkItem(19, 19, 0x307000, "Other-ver114_344.png"));
        this.artworkItems.add(new ArtworkItem(303, 46, 0x308000, "Other-ver114_345.png"));
        this.artworkItems.add(new ArtworkItem(1, 17, 3235840, "Other-ver114_346.png"));
        this.artworkItems.add(new ArtworkItem(1, 14, 3239936, "Other-ver114_347.png"));
        this.artworkItems.add(new ArtworkItem(303, 46, 3244032, "Other-ver114_348.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 3301376, "Other-ver114_349.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 3309568, "Other-ver114_350.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 3325952, "Other-ver114_351.png"));
        this.artworkItems.add(new ArtworkItem(15, 216, 3334144, "Other-ver114_352.png"));
        this.artworkItems.add(new ArtworkItem(9, 44, 0x332000, "Other-ver114_353.png"));
        this.artworkItems.add(new ArtworkItem(1, 48, 0x333000, "Other-ver114_354.png"));
        this.artworkItems.add(new ArtworkItem(1, 62, 0x334000, "Other-ver114_355.png"));
        this.artworkItems.add(new ArtworkItem(1, 216, 0x335000, "Other-ver114_356.png"));
        this.artworkItems.add(new ArtworkItem(9, 216, 0x337000, "Other-ver114_357.png"));
        this.artworkItems.add(new ArtworkItem(13, 13, 0x33B000, "Other-ver114_358.png"));
        this.artworkItems.add(new ArtworkItem(24, 26, 0x33C000, "Other-ver114_359.png"));
    }

    private void initKeyboard_Japanese_ver114() {
        this.artworkItems = new Vector(57);
        this.artworkItems.add(new ArtworkItem(55, 35, 0, "Keyboard_Japanese-ver114_00.png"));
        this.artworkItems.add(new ArtworkItem(80, 29, 8192, "Keyboard_Japanese-ver114_01.png"));
        this.artworkItems.add(new ArtworkItem(43, 29, 20480, "Keyboard_Japanese-ver114_02.png"));
        this.artworkItems.add(new ArtworkItem(43, 28, 28672, "Keyboard_Japanese-ver114_03.png"));
        this.artworkItems.add(new ArtworkItem(80, 29, 36864, "Keyboard_Japanese-ver114_04.png"));
        this.artworkItems.add(new ArtworkItem(43, 29, 49152, "Keyboard_Japanese-ver114_05.png"));
        this.artworkItems.add(new ArtworkItem(43, 29, 57344, "Keyboard_Japanese-ver114_06.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 65536, "Keyboard_Japanese-ver114_07.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 77824, "Keyboard_Japanese-ver114_08.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 90112, "Keyboard_Japanese-ver114_09.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 102400, "Keyboard_Japanese-ver114_10.png"));
        this.artworkItems.add(new ArtworkItem(64, 35, 114688, "Keyboard_Japanese-ver114_11.png"));
        this.artworkItems.add(new ArtworkItem(37, 33, 126976, "Keyboard_Japanese-ver114_12.png"));
        this.artworkItems.add(new ArtworkItem(41, 36, 135168, "Keyboard_Japanese-ver114_13.png"));
        this.artworkItems.add(new ArtworkItem(43, 34, 143360, "Keyboard_Japanese-ver114_14.png"));
        this.artworkItems.add(new ArtworkItem(38, 29, 151552, "Keyboard_Japanese-ver114_15.png"));
        this.artworkItems.add(new ArtworkItem(38, 29, 159744, "Keyboard_Japanese-ver114_16.png"));
        this.artworkItems.add(new ArtworkItem(43, 35, 167936, "Keyboard_Japanese-ver114_17.png"));
        this.artworkItems.add(new ArtworkItem(37, 29, 176128, "Keyboard_Japanese-ver114_18.png"));
        this.artworkItems.add(new ArtworkItem(37, 28, 184320, "Keyboard_Japanese-ver114_19.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 192512, "Keyboard_Japanese-ver114_20.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 204800, "Keyboard_Japanese-ver114_21.png"));
        this.artworkItems.add(new ArtworkItem(74, 23, 217088, "Keyboard_Japanese-ver114_22.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 225280, "Keyboard_Japanese-ver114_23.png"));
        this.artworkItems.add(new ArtworkItem(74, 23, 237568, "Keyboard_Japanese-ver114_24.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 245760, "Keyboard_Japanese-ver114_25.png"));
        this.artworkItems.add(new ArtworkItem(13, 26, 258048, "Keyboard_Japanese-ver114_26.png"));
        this.artworkItems.add(new ArtworkItem(13, 26, 262144, "Keyboard_Japanese-ver114_27.png"));
        this.artworkItems.add(new ArtworkItem(1, 26, 266240, "Keyboard_Japanese-ver114_28.png"));
        this.artworkItems.add(new ArtworkItem(1, 26, 270336, "Keyboard_Japanese-ver114_29.png"));
        this.artworkItems.add(new ArtworkItem(7, 11, 274432, "Keyboard_Japanese-ver114_30.png"));
        this.artworkItems.add(new ArtworkItem(17, 66, 278528, "Keyboard_Japanese-ver114_31.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 286720, "Keyboard_Japanese-ver114_32.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 634880, "Keyboard_Japanese-ver114_33.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 913408, "Keyboard_Japanese-ver114_34.png"));
        this.artworkItems.add(new ArtworkItem(7, 11, 1191936, "Keyboard_Japanese-ver114_35.png"));
        this.artworkItems.add(new ArtworkItem(17, 66, 1196032, "Keyboard_Japanese-ver114_36.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 1204224, "Keyboard_Japanese-ver114_37.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 1552384, "Keyboard_Japanese-ver114_38.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 0x1D0000, "Keyboard_Japanese-ver114_39.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 2179072, "Keyboard_Japanese-ver114_40.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 2457600, "Keyboard_Japanese-ver114_41.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 2736128, "Keyboard_Japanese-ver114_42.png"));
        this.artworkItems.add(new ArtworkItem(96, 34, 0x2E0000, "Keyboard_Japanese-ver114_43.png"));
        this.artworkItems.add(new ArtworkItem(74, 23, 3031040, "Keyboard_Japanese-ver114_44.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 3039232, "Keyboard_Japanese-ver114_45.png"));
        this.artworkItems.add(new ArtworkItem(96, 34, 3051520, "Keyboard_Japanese-ver114_46.png"));
        this.artworkItems.add(new ArtworkItem(13, 26, 3067904, "Keyboard_Japanese-ver114_47.png"));
        this.artworkItems.add(new ArtworkItem(13, 26, 0x2EE000, "Keyboard_Japanese-ver114_48.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 3076096, "Keyboard_Japanese-ver114_49.png"));
        this.artworkItems.add(new ArtworkItem(79, 28, 0x2F2000, "Keyboard_Japanese-ver114_50.png"));
        this.artworkItems.add(new ArtworkItem(279, 34, 3100672, "Keyboard_Japanese-ver114_51.png"));
        this.artworkItems.add(new ArtworkItem(154, 23, 0x2FF000, "Keyboard_Japanese-ver114_52.png"));
        this.artworkItems.add(new ArtworkItem(158, 28, 0x303000, "Keyboard_Japanese-ver114_53.png"));
        this.artworkItems.add(new ArtworkItem(480, 180, 0x308000, "Keyboard_Japanese-ver114_54.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 3526656, "Keyboard_Japanese-ver114_55.png"));
        this.artworkItems.add(new ArtworkItem(320, 216, 3805184, "Keyboard_Japanese-ver114_56.png"));
    }
}

