/*
 * Decompiled with CFR 0.152.
 */
package ee.rumba.iPhoneShop.dictionary;

import ee.rumba.iPhoneShop.dictionary.iDictionary;
import ee.rumba.iPhoneShop.dictionary.iWord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class Main {
    public static void printUsage() {
        System.out.println("Usage: java -jar iPhoneShop.jar KDICT command");
        System.out.println("   dump /path/to/english-unigrams.dat");
        System.out.println(" create /path/to/textDBFile.txt    (must be UTF-8 and \\n terminated lines)");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            Main.printUsage();
        }
        File file = new File(stringArray[1]);
        String string = stringArray[0].toUpperCase();
        if (!file.canRead()) {
            System.out.println("Unable to read file " + file.getAbsolutePath());
            Main.printUsage();
        }
        if (string.trim().toUpperCase().equals("DUMP")) {
            iDictionary iDictionary2 = iDictionary.parseUnigramsDat(file);
            iDictionary2.writeTextDump(new File(file.getName() + ".txt"));
        } else if (string.trim().toUpperCase().equals("CREATE")) {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            iDictionary iDictionary3 = new iDictionary();
            String string3 = bufferedReader.readLine();
            if (!string3.equals("UTF8Word\tX-Boolean\tWeight")) {
                throw new IllegalArgumentException("Source file is not valid\nit must have header and format\n\"UTF8Word\\tX-Boolean\\tWeight\\n\"");
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray2 = string2.split("\t");
                if (stringArray2.length != 3) {
                    throw new IllegalArgumentException("Unknown line: \"" + string2 + "\"");
                }
                String string4 = new String(stringArray2[0].getBytes(), "UTF-8");
                boolean bl = stringArray2[1].equals("true");
                int n = Integer.parseInt(stringArray2[2]);
                iDictionary3.addiWord(new iWord(string4, n, bl));
            }
            iDictionary3.writeUnigramsDat(new File("en_US-unigrams.dat"));
            iDictionary3.writeUnigramsIdx(new File("en_US-unigrams.idx"));
            iDictionary3.writeStemsDat(new File("en_US-stems.dat"));
            iDictionary3.writeTextDump(new File("english-unigrams.dat.debug.txt"));
            System.out.println("Created dictionary, please check english-unigrams.dat.debug.txt before copying binary files to iPhone");
        } else {
            Main.printUsage();
        }
    }
}

