/*
 * Decompiled with CFR 0.152.
 */
package ee.rumba.iPhoneShop.dictionary;

import ee.rumba.iPhoneShop.dictionary.iWord;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class iDictionary {
    private boolean sorted = false;
    Vector<iWord> iWordVector = new Vector(1000, 1000);

    public String toString() {
        return "iDictionary with " + this.iWordVector.size() + " words";
    }

    public void addiWord(iWord iWord2) {
        this.iWordVector.add(iWord2);
        this.sorted = false;
    }

    public void writeTextDump(File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write("UTF8Word\tX-Boolean\tWeight\n".getBytes());
        boolean bl = false;
        for (iWord iWord2 : this.iWordVector) {
            fileOutputStream.write(iWord2.toString().getBytes("UTF-8"));
            fileOutputStream.write("\n".getBytes());
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        System.out.println("Text dump written into file " + file.getAbsolutePath());
    }

    public void writeStemsDat(File file) throws Exception {
        int n;
        Vector vector;
        Object v;
        int n2;
        Object object;
        Object object2;
        if (!this.sorted) {
            throw new IllegalArgumentException("UnigramsIdx can be only created after execute of writeUnigramsDat");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1000, 1000.0f);
        for (iWord object32 : this.iWordVector) {
            object2 = object32.get3FirstAnsiChars();
            object = ((String)object2).substring(0, 2) + " ";
            if (!hashMap.containsKey(object2) && this.validSteam((String)object2)) {
                hashMap.put((String)object2, (String)object2);
            }
            if (hashMap.containsKey(object) || !this.validSteam((String)object)) continue;
            hashMap.put((String)object, (String)object2);
        }
        Iterator<iWord> iterator = hashMap.keySet().iterator();
        Vector<iWord> vector2 = new Vector<iWord>(hashMap.size());
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Collections.sort(vector2);
        object2 = this.getiKeyboard();
        object = new HashMap(1000, 1000.0f);
        for (String n3 : vector2) {
            ((HashMap)object).put(n3, this.genMutants(n3, hashMap, (HashMap<Character, char[]>)object2));
        }
        int n3 = n2 = vector2.size() * 7;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(iWord.createIntBytes(n2));
        for (String string : vector2) {
            byteArrayOutputStream.write(string.getBytes());
            byteArrayOutputStream.write(iWord.createIntBytes(n3));
            v = ((HashMap)object).get(string);
            vector = null;
            if (v instanceof Vector) {
                vector = (Vector)v;
            }
            n = 0;
            for (String string2 : vector) {
                n += string2.length() + 1;
            }
            n3 += n + 1;
        }
        for (String string : vector2) {
            v = ((HashMap)object).get(string);
            vector = (Vector)v;
            n = 0;
            for (String string2 : vector) {
                byteArrayOutputStream.write(string2.getBytes());
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(0);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byteArrayOutputStream.toByteArray());
        fileOutputStream.flush();
        fileOutputStream.close();
        System.out.println("Stems written into " + file.getAbsolutePath());
    }

    public void writeUnigramsIdx(File file) throws Exception {
        if (!this.sorted) {
            throw new IllegalArgumentException("UnigramsIdx can be only created after execute of writeUnigramsDat");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        iWord iWord2 = null;
        for (iWord iWord3 : this.iWordVector) {
            if (iWord2 != null && iWord2.compareIndexChars(iWord3)) continue;
            iWord2 = iWord3;
            byteArrayOutputStream.write(iWord2.getIndexBytes());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byteArrayOutputStream.toByteArray());
        fileOutputStream.flush();
        fileOutputStream.close();
        System.out.println("Index written into " + file.getAbsolutePath());
    }

    public void writeUnigramsDat(File file) throws Exception {
        System.out.println("Start Unigrams.dat write");
        if (!this.sorted) {
            System.out.println("Starts sorting " + this.iWordVector.size() + " words");
            this.sort();
            System.out.println("Sorting done");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(iWord.createIntBytes(this.iWordVector.size()));
        for (iWord iWord2 : this.iWordVector) {
            byteArrayOutputStream.write(iWord2.createBinaryWord(byteArrayOutputStream.size()));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byteArrayOutputStream.toByteArray());
        fileOutputStream.flush();
        fileOutputStream.close();
        System.out.println("Unigrams written into " + file.getAbsolutePath());
    }

    private void sort() {
        Collections.sort(this.iWordVector);
        this.sorted = true;
    }

    public static iDictionary parseUnigramsDat(File file) throws Exception {
        iDictionary iDictionary2 = new iDictionary();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        int n = fileInputStream.read(byArray);
        if (n != (int)file.length()) {
            throw new IOException("Unable to read full file into memory");
        }
        int n2 = 0;
        int n3 = iWord.readInt(byArray, n2);
        n2 += 4;
        int n4 = 0;
        while (n2 < n) {
            int n5;
            int n6 = iWord.readShort(byArray, n2);
            n2 += 2;
            int n7 = byArray[n2++] & 0xFF;
            int n8 = byArray[n2++] & 0xFF;
            int n9 = iWord.getUnicodeLen(n6);
            boolean bl = false;
            int n10 = 0;
            if (((long)n8 & 1L) != 0L) {
                n10 = iWord.readInt(byArray, n2);
                n2 += 4;
            }
            if (((long)n8 & 2L) != 0L) {
                bl = true;
            }
            if (n8 >> 2 != 0) {
                throw new IllegalArgumentException("Broken dictionary file, extraBits byte have more than 2 bits info");
            }
            byte[] byArray2 = new byte[255];
            int n11 = 0;
            int n12 = 0;
            while (byArray[n2] != 0 && n12 < byArray2.length) {
                byArray2[n11] = byArray[n2];
                if ((byArray[n2] & 0xFF) != 194 && (byArray[n2] & 0xFF) != 195 && (byArray[n2] & 0xFF) != 196 && (byArray[n2] & 0xFF) != 197) {
                    ++n12;
                }
                ++n11;
                ++n2;
            }
            if (n9 != 0 && n9 != n12) {
                throw new IllegalArgumentException("Broken dictionary file: @ position " + n2);
            }
            ++n2;
            String string = new String(byArray2, 0, n11, "UTF-8");
            if (n10 != 0) {
                string = iDictionary.makeUpperCase(string, n10);
            }
            if ((n5 = iWord.createWordLenghtBits(string)) != n6) {
                System.out.println(string);
                System.out.println(iDictionary.getBits(n5, 16));
                System.out.println(iDictionary.getBits(n6, 16));
                System.out.println();
            }
            int n13 = 0;
            if (n10 != 0) {
                n13 = (int)((long)n13 | 1L);
            }
            n13 |= 2;
            iDictionary2.addiWord(new iWord(string, n7, bl));
            ++n4;
        }
        if (n4 != n3) {
            throw new IllegalArgumentException("Broken dictionary file");
        }
        return iDictionary2;
    }

    private static String makeUpperCase(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            if ((n & 1 << i) != 0) {
                stringBuffer.append(string2.toUpperCase());
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private boolean validSteam(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        int n2 = 0;
        for (byte by : byArray) {
            if (by >= 48 && by <= 57) {
                ++n2;
            }
            if (by != 32) continue;
            ++n;
        }
        return n < 2 && n2 == 0;
    }

    public Vector<String> genMutants(String string, HashMap<String, String> hashMap, HashMap<Character, char[]> hashMap2) {
        char c;
        Vector<String> vector = new Vector<String>(10, 10);
        char[] cArray = hashMap2.get(Character.valueOf(string.charAt(0)));
        char[] cArray2 = hashMap2.get(Character.valueOf(string.charAt(1)));
        char[] cArray3 = hashMap2.get(Character.valueOf(string.charAt(2)));
        if (cArray == null) {
            c = string.charAt(0);
            cArray = new char[]{c, c, c, c, c, c, c, c};
        }
        if (cArray2 == null) {
            c = string.charAt(1);
            cArray2 = new char[]{c, c, c, c, c, c, c, c};
        }
        if (cArray3 == null) {
            c = string.charAt(2);
            cArray3 = new char[]{c, c, c, c, c, c, c, c};
        }
        for (char c2 : cArray) {
            for (char c3 : cArray2) {
                for (char c4 : cArray3) {
                    char[] cArray4 = new char[]{c2, c3, c4};
                    String string2 = new String(cArray4);
                    if (!hashMap.containsKey(string2) || cArray4[0] != string.charAt(0) && cArray4[1] != string.charAt(1) && cArray4[2] != string.charAt(2)) continue;
                    vector.add(string2.trim());
                }
            }
        }
        return vector;
    }

    private HashMap<Character, char[]> getiKeyboard() {
        HashMap<Character, char[]> hashMap = new HashMap<Character, char[]>(27);
        hashMap.put(Character.valueOf('q'), new char[]{'q', 'w', 'a'});
        hashMap.put(Character.valueOf('w'), new char[]{'w', 'e', 'q', 'a', 's'});
        hashMap.put(Character.valueOf('e'), new char[]{'e', 'r', 'w', 's', 'd'});
        hashMap.put(Character.valueOf('r'), new char[]{'r', 't', 'e', 'd', 'f'});
        hashMap.put(Character.valueOf('t'), new char[]{'t', 'y', 'r', 'f', 'g'});
        hashMap.put(Character.valueOf('y'), new char[]{'y', 'u', 't', 'g', 'h'});
        hashMap.put(Character.valueOf('u'), new char[]{'u', 'i', 'y', 'h', 'j'});
        hashMap.put(Character.valueOf('i'), new char[]{'i', 'o', 'u', 'j', 'k'});
        hashMap.put(Character.valueOf('o'), new char[]{'o', 'p', 'i', 'k', 'l'});
        hashMap.put(Character.valueOf('p'), new char[]{'p', 'o', 'l'});
        hashMap.put(Character.valueOf('a'), new char[]{'a', 's', 'w', 'z'});
        hashMap.put(Character.valueOf('s'), new char[]{'s', 'd', 'a', 'z', 'w', 'e', 'x'});
        hashMap.put(Character.valueOf('d'), new char[]{'d', 'f', 's', 'x', 'e', 'r', 'z', 'c'});
        hashMap.put(Character.valueOf('f'), new char[]{'f', 'g', 'd', 'c', 'r', 't', 'x', 'v'});
        hashMap.put(Character.valueOf('g'), new char[]{'g', 'h', 'f', 'v', 't', 'y', 'c', 'b'});
        hashMap.put(Character.valueOf('h'), new char[]{'h', 'j', 'g', 'b', 'y', 'u', 'v', 'n'});
        hashMap.put(Character.valueOf('j'), new char[]{'j', 'k', 'h', 'n', 'u', 'i', 'b', 'm'});
        hashMap.put(Character.valueOf('k'), new char[]{'k', 'l', 'j', 'm', 'i', 'o', 'n'});
        hashMap.put(Character.valueOf('l'), new char[]{'l', 'k', 'o', 'p', 'm'});
        hashMap.put(Character.valueOf('z'), new char[]{'z', 'x', 's', 'a', 'd'});
        hashMap.put(Character.valueOf('x'), new char[]{'x', 'c', 'z', 'd', 's', 'f'});
        hashMap.put(Character.valueOf('c'), new char[]{'c', 'v', 'x', 'f', 'd', 'g'});
        hashMap.put(Character.valueOf('v'), new char[]{'v', 'b', 'c', 'g', 'f', 'h'});
        hashMap.put(Character.valueOf('b'), new char[]{'b', 'n', 'v', 'h', 'g', 'j'});
        hashMap.put(Character.valueOf('n'), new char[]{'n', 'm', 'b', 'j', 'h', 'k'});
        hashMap.put(Character.valueOf('m'), new char[]{'m', 'n', 'k', 'j', 'l'});
        hashMap.put(Character.valueOf(' '), new char[]{' '});
        return hashMap;
    }

    private static String getBits(long l, int n) {
        String string = Long.toBinaryString(l);
        for (int i = string.length(); i < n; ++i) {
            string = "0" + string;
        }
        return string;
    }

    private static String get32Bits(long l) {
        char[] cArray = new char[32];
        int n = 32;
        int n2 = 2;
        long l2 = 1L;
        do {
            cArray[--n] = (l & l2) == 0L ? 48 : 49;
            l >>>= 1;
        } while (n != 0);
        return new String(cArray);
    }
}

