/*
 * Decompiled with CFR 0.152.
 */
package ee.rumba.iPhoneShop.dictionary;

import sun.text.Normalizer;

public class iWord
implements Comparable {
    public static final long CASE_SENSITIVE = 1L;
    public static final long UNKNOWN_BIT = 2L;
    public static final long LENGHT_BITS = 0xFFE00000L;
    private String utf8Word;
    private int weightBits;
    private boolean unknownBit;
    private int filePosition;

    public iWord(String string, int n, boolean bl) {
        this.utf8Word = string;
        this.weightBits = n;
        this.unknownBit = bl;
    }

    public boolean isUnknownBit() {
        return this.unknownBit;
    }

    public int getWeightBits() {
        return this.weightBits;
    }

    public String toString() {
        return this.utf8Word + "\t" + this.unknownBit + "\t" + this.weightBits;
    }

    public String getUtf8Word() {
        return this.utf8Word;
    }

    public int getFilePosition() {
        return this.filePosition;
    }

    public byte[] calcIndex3Bytes(String string) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = iWord.onlyLetters(iWord.removeAccent(string.toLowerCase())).getBytes();
        int n = 0;
        int n2 = 0;
        while (n < 3 && n2 < byArray2.length) {
            byte by;
            if ((by = byArray2[n2++]) >= 97 && by <= 122) {
                byArray[n++] = (byte)((by - 97) * 2 + 40);
                continue;
            }
            if (by >= 48 && by <= 57) {
                byArray[n++] = 37;
                if (n >= 3) continue;
                byArray[n++] = (byte)((by - 48) * 2 + 122);
                continue;
            }
            throw new IllegalArgumentException("Index string calculation failed");
        }
        return byArray;
    }

    public byte[] getIndexBytes() {
        byte[] byArray = new byte[7];
        System.arraycopy(this.calcIndex3Bytes(this.utf8Word), 0, byArray, 0, 3);
        System.arraycopy(iWord.createIntBytes(this.filePosition), 0, byArray, 3, 4);
        return byArray;
    }

    public static String onlyLetters(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((c < 'a' || c > 'z') && (c < '0' || c > '9')) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public int compareTo(iWord iWord2) {
        String string = iWord.onlyLetters(iWord.removeAccent(this.utf8Word.toLowerCase()));
        String string2 = iWord.onlyLetters(iWord.removeAccent(iWord2.getUtf8Word().toLowerCase()));
        for (int i = 0; i < string.length() && i < string2.length(); ++i) {
            if (string.charAt(i) > string2.charAt(i)) {
                return 1;
            }
            if (string.charAt(i) >= string2.charAt(i)) continue;
            return -1;
        }
        if (string.length() > string2.length()) {
            return 1;
        }
        if (string.length() < string2.length()) {
            return -1;
        }
        return 0;
    }

    public boolean compareIndexChars(iWord iWord2) {
        byte[] byArray = this.calcIndex3Bytes(this.utf8Word);
        byte[] byArray2 = this.calcIndex3Bytes(iWord2.getUtf8Word().toLowerCase());
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public String get3FirstAnsiChars() {
        return iWord.trimTo3Chars(iWord.onlyLetters(iWord.removeAccent(this.utf8Word.toLowerCase())));
    }

    private static String trimTo3Chars(String string) {
        StringBuffer stringBuffer = new StringBuffer(3);
        for (int i = 0; i < 3; ++i) {
            if (string.length() > i) {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String removeAccent(String string) {
        String string2 = string;
        if (string2.indexOf(230) != -1) {
            string2 = string2.replaceAll("\u00e6", "ae");
        }
        if (string2.indexOf(186) != -1) {
            string2 = string2.replaceAll("\u00ba", "o");
        }
        string2 = Normalizer.normalize((String)string2, (Normalizer.Mode)Normalizer.DECOMP, (int)0);
        string2 = string2.replaceAll("[^\\p{ASCII}]", "");
        return string2;
    }

    public int compareTo(Object object) {
        iWord iWord2 = (iWord)object;
        return this.compareTo(iWord2);
    }

    public byte[] createBinaryWord(int n) throws Exception {
        byte[] byArray;
        this.filePosition = n;
        int n2 = 0;
        String string = this.utf8Word.toLowerCase();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == this.utf8Word.charAt(i)) continue;
            n2 |= 1 << i;
        }
        byte[] byArray2 = string.getBytes("UTF-8");
        int n3 = iWord.createWordLenghtBits(string);
        int n4 = 0;
        if (this.unknownBit) {
            n4 = (int)((long)n4 | 2L);
        }
        if (n2 != 0) {
            n4 = (int)((long)n4 | 1L);
            byArray = new byte[9 + byArray2.length];
            byArray[0] = (byte)((n3 & 0xFFFF) >> 8);
            byArray[1] = (byte)(n3 & 0xFF);
            byArray[2] = (byte)(this.weightBits & 0xFF);
            byArray[3] = (byte)n4;
            System.arraycopy(iWord.createIntBytes(n2), 0, byArray, 4, 4);
            System.arraycopy(byArray2, 0, byArray, 8, byArray2.length);
        } else {
            byArray = new byte[5 + byArray2.length];
            byArray[0] = (byte)((n3 & 0xFFFF) >> 8);
            byArray[1] = (byte)(n3 & 0xFF);
            byArray[2] = (byte)(this.weightBits & 0xFF);
            byArray[3] = (byte)n4;
            System.arraycopy(byArray2, 0, byArray, 4, byArray2.length);
        }
        return byArray;
    }

    public static int readInt(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24;
        n2 |= (byArray[n + 1] & 0xFF) << 16;
        n2 |= (byArray[n + 2] & 0xFF) << 8;
        return n2 |= byArray[n + 3] & 0xFF;
    }

    public static int readShort(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 8;
        return n2 |= byArray[n + 1] & 0xFF;
    }

    public static byte[] createIntBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    private static int getExtraXXX(String string) {
        String string2 = string.toLowerCase();
        int n = 0;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) >= '0' && string2.charAt(i) <= '9') {
                ++n;
                continue;
            }
            if (string2.charAt(i) >= 'a' && string2.charAt(i) <= 'z' || string2.charAt(i) == '\u00e6' || string2.charAt(i) == '\u00df') continue;
            --n;
        }
        return n;
    }

    public static int createWordLenghtBits(String string) {
        try {
            int n = string.length();
            int n2 = string.getBytes("UTF-8").length;
            int n3 = n2 + 1;
            int n4 = n2 & 7;
            n4 <<= 5;
            n4 |= n;
            n4 <<= 6;
            n4 |= (n3 += iWord.getExtraXXX(string));
            n4 <<= 2;
            return n4 |= n2 >> 3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static int getUnicodeLen(int n) {
        return n >> 8 & 0x1F;
    }
}

